#ifndef PAMVMCTRKDIG_H
#define PAMVMCTRKDIG_H


#include <iostream>

#include "PamVMCTrkF77GpsSpe.h"
#include "CalibTrk1Event.h"
#include "CalibTrk2Event.h"
#include "PamVMCDigitizer.h"
#include "PamVMCTrkF77GpsSpe.h" 


class PamVMCTrkDig: public PamVMCDigitizer{
  

 public:
  PamVMCTrkDig():PamVMCDigitizer("Tracker")
    {  
      fextrnd = new TRandom3(0);    
      fextrnd->SetName("TRKEXT");
      frnd->RegisterRandom("TRKEXT", fextrnd);
    };
  
  virtual ~PamVMCTrkDig(){ delete fextrnd;  };

  void LoadCalib(){
    LoadFile();
    DigitizeTrackCalib(1);
    UInt_t length=fData.size()*2;
    DigitizePSCU(length,0x12);
    AddPadding();
    WriteCalib();

    DigitizeTrackCalib(2);
    length=fData.size()*2;
    DigitizePSCU(length,0x13);
    AddPadding();
    WriteCalib();

    LoadMipCor();
  }

  /*Setting a pointer to random number if needed */
  virtual void SetRandom(TRandom3* random){
    *frandom = *random;
    frandom->SetName(fdname);
    SetRandomExt( random );
  }

  virtual void SetRandomExt(TRandom3* random){
    *fextrnd = *random;
    fextrnd->SetName("TRKEXT");
  }


  void RegisterTrkData(pGPSSPEHits * hits){ fhits = hits; }
        
  void Digitize();

  void PrintCollections(){
    cout<<"HitCollection for Tracker: "<<fhits<<endl;
  }


  private:
 


  //AUX functions//
  
  void LoadFile();
  
  void WriteCalib();
  
  void LoadMipCor();

  void DigitizeTrackCalib(Int_t n);
  
  void BrokenStrip(Int_t planebr, Int_t vabr, Int_t plane, 
		   Int_t strip, Int_t & goodst){
    if(plane==planebr && strip>=(256*(vabr-1)) && strip<(256*vabr)) 
      goodst=strip-(256*(vabr-1));
  }

  Float_t SaturationTrackx(Float_t ADC);

  Float_t SaturationTracky(Float_t ADC);

  void CompressTrackData();
  
  static const Int_t fNviews = 12;
  static const Int_t fNladder=3;
  static const Int_t fNstrips_ladder = 1024;
  static const Int_t fNstrips_view = 3072;

  static const Float_t fSigmaCommon = 25.; // to be adjusted
  static const Int_t fCutzop = 4;
  static const Int_t fCutclu = 7;
  static const Int_t fNclst = 2;


  Float_t  fSigmaTrack[fNviews][fNstrips_view];
  Float_t  fPedeTrack[fNviews][fNstrips_view];
  

  Float_t  AdcTrack[fNviews][fNstrips_view];//Vector of strips to be compressed

  //UShort_t fDataTrack[fTRACKbuffer];
  //UInt_t   fTracklength; //  Actual length of buffer 
  Float_t  fMipCor[fNladder][fNviews] ;
  // end vectors, buffer, and variables for tracker 

  TRandom3 * fextrnd;

  pGPSSPEHits * fhits; //pointer to Tracker's SD hit data

  ClassDef(PamVMCTrkDig,1)

};



#endif // PAMVMCTRKSD_H
