#ifndef PAMVMC_TRK_HIT_H
#define PAMVMC_TRK_HIT_H
#include <cmath>
#include <iostream>

#include <TObject.h>
#include <TVirtualMC.h>
#include <TParticle.h>

#include "PamVMCGeoID.h"
#include "PamVMCDetectorHit.h"

using std::sqrt;
using std::cout;
using std::endl;

class pTrkHitData: public TObject {

public:
  Int_t    fNXMULT;
  Int_t    fNYMULT;    //Particle PDG
  Float_t fXAVESPE;   //PATH length in specific SD in (cm)
  Float_t fYAVESPE;
  Float_t fZAVESPE;

  pTrkHitData():  fNXMULT(0), fNYMULT(0), 
    fXAVESPE(0.), fYAVESPE(0.), fZAVESPE(0.) { };
  virtual ~pTrkHitData(){ ; };

  // Kept for back-compatibility
  void Clean() {
    fNXMULT = fNYMULT = 0;
    fXAVESPE = fYAVESPE = fZAVESPE = 0.;
  }

  void Clear( Option_t * = "") { Clean(); }

  void Print(Option_t * ="" ) const
  { cout << "pTRKHitData: "<<endl
         <<"NXMULT: "<<fNXMULT<<endl
	 <<"NYMULT: "<<fNYMULT<<endl
	 <<"XAVESPE: "<<fXAVESPE<<endl
	 <<"YAVESPE: "<<fYAVESPE<<endl
	 <<"ZAVESPE: "<<fZAVESPE<<endl; } 
  
  ClassDef(pTrkHitData,1)

};


pTrkHitData & operator+=( pTrkHitData &a, const pTrkHitData & p); 


class PamVMCTrkHit : public PamVMCDetectorHit
{
  public:
    PamVMCTrkHit();
    virtual ~PamVMCTrkHit();

    //Set and Add methods

    virtual void CleanHit(){
      PamVMCDetectorHit::CleanHit();
      ftrkhitdata.Clean();
    }

    
    void Clear(Option_t * = "") { this->~PamVMCTrkHit(); }

    pTrkHitData * GenTrkHit() { return new pTrkHitData(ftrkhitdata);}


    void operator = (const PamVMCTrkHit & );

    void SetNXMULT     (Int_t xmult)      { ftrkhitdata.fNXMULT = xmult; }    
    void SetNYMULT     (Int_t ymult)      { ftrkhitdata.fNYMULT = ymult; }
    void SetXAVESPE    (Float_t xave)     { ftrkhitdata.fXAVESPE = xave; }
    void SetYAVESPE    (Float_t yave)     { ftrkhitdata.fYAVESPE = yave; }
    void SetZAVESPE    (Float_t zave)     { ftrkhitdata.fZAVESPE = zave; }
    //void Reset(); 
                 
    // Get methods

    const pTrkHitData *GetTrkHit() {return &ftrkhitdata;}
    Int_t    GetNXMULT()      { return ftrkhitdata.fNXMULT;  };
    Int_t    GetNYMULT()      { return ftrkhitdata.fNYMULT;  };
    Float_t GetXAVESPE()      { return ftrkhitdata.fXAVESPE; };
    Float_t GetYAVESPE()      { return ftrkhitdata.fYAVESPE; };
    Float_t GetZAVESPE()      { return ftrkhitdata.fZAVESPE; };
   
    
 protected:

    pTrkHitData ftrkhitdata;

  ClassDef(PamVMCTrkHit,1) //PamVMCTrkHit  
};

#endif //PAMVMC_TRK_HIT_H
