#ifndef PCOMBTRANS_H
#define PCOMBTRANS_H
#include <iostream>
#include <map>
#include "TObject.h"

struct pCombTrans : public TObject {
  Double_t fomega;
  Double_t fbeta;
  Double_t fgamma;
  Double_t fdx;
  Double_t fdy;
  Double_t fdz;

  pCombTrans(): fomega(0.), fbeta(0.), fgamma(0.), fdx(0.), fdy(0.), fdz(0.){};
  pCombTrans(Double_t omega, Double_t beta, Double_t gamma, Double_t dx, Double_t dy, Double_t dz): fomega(omega), fbeta(beta), fgamma(gamma), fdx(dx), fdy(dy), fdz(dz){};
  ~pCombTrans() { };
};

typedef map<Int_t, pCombTrans*> CombTransMap;

#endif //PCOMBTRANS

