#ifndef PAMVMCTRKID_H
#define PAMVMCTRKID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define TRKOF 2

using std::cout;
using std::endl;

struct pTrkID: public pGeoID {
  Int_t plNo;
  Int_t padNo;
 

  pTrkID(): plNo(-1), padNo(-1) {};
  pTrkID(Int_t offset): pGeoID(offset), plNo(-1), padNo(-1) {};
  pTrkID & operator = (const pTrkID &pid) {
    plNo=pid.plNo;
    padNo=pid.padNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
	gMC->CurrentVolOffID(2,plNo);
	Int_t TRSL;
        gMC->CurrentVolOffID(1,TRSL);       
	padNo = TRSL-(plNo-1)*6;
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return (plNo-1)*6+padNo; }

  void Print(const Option_t* ="") const { 
    cout << " pTrkID : plNo " << plNo <<endl;
    cout << " pTrkID : padNo " << padNo <<endl;
  }

};
#endif //PAMVMCTrkID_H
