#ifndef PAMVMC_DET_TRK_H
#define PAMVMC_DET_TRK_H

#include "TVector3.h"
#include "PamVMCDetector.h"
#include "pCombTrans.h"
#include "PamVMCTrkSD.h"

#define NP_TRK 6

class PamVMCTrkSD;

class PamVMCDetTrk  : public PamVMCDetector {

  Double_t dxflo[NP_TRK*NP_TRK], dyflo[NP_TRK*NP_TRK];
  CombTransMap fctmap;
  void ReadPaddlesPos();
 public:


 PamVMCDetTrk():PamVMCDetector("Tracker") 
    {;  };
  
  ~PamVMCDetTrk(){
    fctmap.clear();
  }

  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "TSPA";
    PamVMCTrkSD *trk = new PamVMCTrkSD();
    fdetSD.Add(new TObjString(t), trk);
    PamVMCSDMgr::Instance()->SetSD(t,trk);
    //insert SD in Field of Volume
    GetVol(t)->SetField(trk);
  }

  ClassDef(PamVMCDetTrk,1)
};


#endif //PAMVMC_DET_TRK_H
