#ifndef PAMVMC_TOF_DIG_H
#define PAMVMC_TOF_DIG_H

#include "PamVMCDigitizer.h"

#define NP 48

using std::cout;
using std::endl;

class PamVMCTofDig  : public PamVMCDigitizer {

  Float_t fatte1[NP], fatte2[NP], flambda1[NP], flambda2[NP];
  Float_t fQevePmt_pC[NP];
  Int_t fADCtof[NP],fTDCint[NP];
  Float_t ftdcres[NP],fc1_S[NP],fc2_S[NP],fc3_S[NP];
  Float_t ftdc[NP],ftdc1[NP],ftdcpmt[NP];
  Bool_t fDEBUG;

  UCBuffer fDataC;

  Float_t TimeRes(Int_t PrimaryPDG);
  //fData TOF 12x23bytes 276bytes
  void DigitizeTofPlane(Int_t planeNo, TClonesArray* HitColl, Int_t PrimaryPDG);
  
  void Paddle2Pmt(Int_t planeNo, Int_t padNo, Int_t *pl, Int_t *pr);

  UChar_t Bin2GrayTof(UChar_t binaTOF,UChar_t grayTOF);

  UChar_t EvaluateCrc(UChar_t *pTrg, Int_t nb);

  void Crc8Tof(UChar_t *oldCRC, UChar_t *crcTof);

 public:


  PamVMCTofDig():PamVMCDigitizer("Tof"){
    for(Int_t i=0; i<NP; i++){
      ftdcres[i] = 50.E-12;             // TDC resolution 50 picosec
      fc1_S[i] = 500.;                  // cable length in channels
      fc2_S[i] = 0.;
      fc3_S[i] = 1000.;
      fc1_S[i] = fc1_S[i]*ftdcres[i];   // cable length in sec 
      fc2_S[i] = fc2_S[i]*ftdcres[i];
    }
  }
  
  virtual ~PamVMCTofDig() {;  }
 
  void Digitize(){; }//not used

  void WriteToBuff(){ fraw->CopyUCharToBuff(&fDataC); }

  void DigitizeTOF(Int_t EventNo, Int_t PrimaryPDG);

  void LoadCalib();

  //AUX
  /*Plane numerations:
  planeNo    KEY   paddles        sizes
   0        S11Y     8        33.0 x 5.1 cm
   1        S12X     6        40.8 x 5.5 cm
   2        S21X     2        18.0 x 7.5 cm
   3        S22Y     2        15.0 x 9.0 cm
   4        S31Y     3        15.0 x 6.0 cm
   5        S32X     3        18.0 x 5.0 cm
  */
  

  ClassDef(PamVMCTofDig,1)
};


#endif //PAMVMC_TOF_DIG_H
