#ifndef PAMVMC_DET_TOF_S2_H
#define PAMVMC_DET_TOF_S2_H

#include "PamVMCDetector.h"

#include "PamVMCTofSD.h"

class PamVMCTofSD;

class PamVMCDetTofS2  : public PamVMCDetector {

 private:

 Bool_t TPLAfirst;

 public:


   PamVMCDetTofS2():PamVMCDetector("S2") 
  {;  };
 
  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "S21X";
    PamVMCTofSD *s21x = new PamVMCTofSD(t);
    fdetSD.Add(new TObjString(t), s21x);
    PamVMCSDMgr::Instance()->SetSD(t,s21x);
    GetVol(t)->SetField(s21x);

    t = "S22Y";
    PamVMCTofSD *s22y = new PamVMCTofSD(t);
    fdetSD.Add(new TObjString(t), s22y);
    PamVMCSDMgr::Instance()->SetSD(t,s22y);
    GetVol(t)->SetField(s22y);
  }

  ClassDef(PamVMCDetTofS2,1)
};


#endif //PAMVMC_DET_TOF_S2_H
