#include "PamVMCDetTofS3.h"

ClassImp(PamVMCDetTofS3)

void PamVMCDetTofS3::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s;

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s); 
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }
  
  s = "MYLAR";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,3,   1.39000    );
    x->SetUniqueID(  29);
    x->DefineElement(0,12.011,6,0.6250159);
    x->DefineElement(1,1.00794,1,0.4196011E-01);
    x->DefineElement(2,15.9994,8,0.3330241);
  }


  TGeoMedium *n=0;


  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "MYLAR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,19,29,-1,1,40,1,100,0.5000000E-01,0.2300000E-04,0.5000000E-03);


  TGeoVolume *v=0;
  s = "S3";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S3",GetMed("N2 GAS"),9.0069,7.5069,0.7819);
  s = "S31M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S31M",GetMed("MYLAR"),3.0023,7.5,0.35345);
  s= "S32M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S32M",GetMed("MYLAR"),9.,2.5023,0.35345);
  s = "S31Y";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S31Y",GetMed("SCINTILLATOR"),3.,7.5,0.35);
  s = "S32X";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S32X",GetMed("SCINTILLATOR"),9.,2.5,0.35);

  GetVol("S3")->AddNode(GetVol("S32M"),1,new TGeoTranslation(0.,-5.0046,-0.42845));
   GetVol("S32M")->AddNode(GetVol("S32X"),1,new TGeoTranslation(0.,0.,-0.115E-02));
  GetVol("S3")->AddNode(GetVol("S32M"),2,new TGeoTranslation(0.,0.,-0.42845));
  GetVol("S3")->AddNode(GetVol("S32M"),3,new TGeoTranslation(0.,5.0046,-0.42845));
  GetVol("S3")->AddNode(GetVol("S31M"),1,new TGeoTranslation(-6.0046,0.,0.42845));
   GetVol("S31M")->AddNode(GetVol("S31Y"),1,new TGeoTranslation(0.,0.,-0.115E-02));
  GetVol("S3")->AddNode(GetVol("S31M"),2,new TGeoTranslation(0.,0.,0.42845));
  GetVol("S3")->AddNode(GetVol("S31M"),3,new TGeoTranslation(6.0046,0.,0.42845));



  SetMotherProp(GetVol("S3"),1,new TGeoTranslation(0.,0.,25.3159));



}

void  PamVMCDetTofS3::DefineCuts(){

  TString s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="MYLAR";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
}

