#include "PamVMCDetTofS2.h"

ClassImp(PamVMCDetTofS2)

void  PamVMCDetTofS2::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s); 
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }
  
  s = "MYLAR";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,3,   1.39000    );
    x->SetUniqueID(  29);
    x->DefineElement(0,12.011,6,0.6250159);
    x->DefineElement(1,1.00794,1,0.4196011E-01);
    x->DefineElement(2,15.9994,8,0.3330241);
  }

  s = "POLYSTYRENE";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,2,  0.350000E-01);
    x->SetUniqueID(  30);
    x->DefineElement(0,12.011,6,0.9225789);
    x->DefineElement(1,1.00794,1,0.7742105E-01);
  }
  TGeoMedium *n=0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "MYLAR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium("MYLAR",19,29,-1,1,40,1,100,0.5000000E-01,0.2300000E-04,0.5000000E-03);

  s = "POLYSTYRENE";
  n = (GetMed(s))?GetMed(s): new TGeoMedium("POLYSTYRENE",20,30,-1,1,40,1,100,0.5000000E-01,0.4000000E-02,0.5000000E-03);

  TGeoVolume *v=0;

  TPLAfirst = kFALSE;


  s = "TPLA"; 
  v = GetVol(s);
  if(!v) {
    v = gGeoManager->MakeBox(s,GetMed("N2 GAS"),28.,27.165,1.6);
    TPLAfirst = kTRUE;
  }
  
  s = "S2";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S2",GetMed("ALUMINIUM"),9.0046,7.5046,0.7476);
  s = "S2A";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S2A",GetMed("N2 GAS"),9.0046,7.5046,0.7146);
  s = "S21M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S21M",GetMed("MYLAR"),9.,3.7523,0.2523);
  s = "S22M";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S22M",GetMed("MYLAR"),4.5023,7.5,0.2523);
  s = "S21X";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S21X",GetMed("SCINTILLATOR"),9.,3.75,0.25);
  s = "S22Y";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("S22Y",GetMed("SCINTILLATOR"),4.5,7.5,0.25);
  s = "POLY";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox("POLY",GetMed("POLYSTYRENE"),9.0046,7.5046,0.2);  

 
  GetVol("S2")->AddNode(GetVol("S2A"),1,gGeoIdentity);
    GetVol("S2A")->AddNode(GetVol("S22M"),1,new TGeoTranslation(-4.5023,0.,-0.4523));
      GetVol("S22M")->AddNode(GetVol("S22Y"),1,gGeoIdentity);
    GetVol("S2A")->AddNode(GetVol("S22M"),2,new TGeoTranslation(4.5023,0.,-0.4523));
    GetVol("S2A")->AddNode(GetVol("S21M"),1,new TGeoTranslation(0.,-3.7523,0.523E-01));
      GetVol("S21M")->AddNode(GetVol("S21X"),1,gGeoIdentity);
    GetVol("S2A")->AddNode(GetVol("S21M"),2,new TGeoTranslation(0.,3.7523,0.523E-01));
    GetVol("S2A")->AddNode(GetVol("POLY"),1,new TGeoTranslation(0.,0.,0.5046));
  
  if(TPLAfirst){
    GetVol("TPLA")->AddNode(GetVol("S2"),1,new TGeoTranslation(0.,0.,-0.3524));
    SetMotherProp(GetVol("TPLA"),1, new TGeoTranslation(0.,0.,73.489));
  } else {
    GetVol("TPLA")->AddNode(GetVol("S2"),1,new TGeoTranslation(0.,0.,-0.3524));
  }


};

void  PamVMCDetTofS2::DefineCuts(){

 TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="MYLAR";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "POLYSTYRENE";
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));

}

