#ifndef PAMVMCNDID_H
#define PAMVMCNDID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define NDOF 1

using std::cout;
using std::endl;

struct pNdID: public pGeoID {
  Int_t tubNo;
 

  pNdID(): tubNo(-1) {};
  pNdID(Int_t offset): pGeoID(offset), tubNo(-1) {};
  pNdID & operator = (const pNdID &pid) {
    tubNo=pid.tubNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      	gMC->CurrentVolOffID(1,tubNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return tubNo; }

  void Print(const Option_t* ="") const { 
    cout << " pNdID : tubNo " << tubNo <<endl;
  }
};




#endif // PAMVMCNdID_H
