#include <iostream>
#include <TString.h>
#include <TObject.h>
#include <TMath.h>
#include <TRandom.h>
#include <TVector2.h>
#include <TVector3.h>

#ifndef PAMVMC2PIAUX_H
#define PAMVMC2PIAUX_H

using std::cout;
using std::endl;
using TMath::Pi;
using TMath::Sin;
using TMath::Cos;
using TMath::ATan;
using TMath::Power;
using TMath::Sqrt;
using TMath::DegToRad;
using TMath::RadToDeg;
using TMath::ACos;
using TMath::ASin;
using TMath::ATan2;
using TMath::TwoPi;

#define SHELL3RR 248.451
#define SHELL3RZ 138.935
#define ZS2MAX (73.1889 + 0.25)
#define XS2 -9.0
#define YS2 -7.5046
#define XS1 20.4184
#define YS1 16.5138
#define ZS1 101.489
#define GPAXCARD (15.7968531 + 1.0)
#define GPAYCARD (13.1706848 + 1.0)
#define RCY 44.3986

#define TWOPIDEBUG 1
 
class PamVMC2PiAux : public TObject {

  TRandom *frandom; //Random object, class is not owner of this SetRandom used
  Double_t fsphar, fzminc, fzmins, fthmax, farea;
  
  void gsurf();
  
 public:

  PamVMC2PiAux() {
    gsurf();
  };

  virtual ~PamVMC2PiAux(){};

  void SetRandom(TRandom *rnd) { frandom = rnd; };

  void GenPosAng(TVector3& pos, TVector2& ang); 

  Double_t GetArea(){ return farea; };

  void Print(const Option_t* ="") const { 
    // Will see .... // 
    cout<<"PAMVMC 2PI GENERATOR INFO:"<<endl;
  };

 
};

#endif //PAMVMC2PIAUX
