#ifndef PAM_VMC_MAT_H
#define PAM_VMC_MAT_H

#include "TObject.h"
#include "TObjArray.h"

struct PamVMCElem : public TObject {
  Int_t fz;
  Double_t  fa, fprc;

  PamVMCElem():fz(0),fa(0.),fprc(0.) {};
  PamVMCElem(Int_t z, Double_t a, Double_t prc): fz(z), fa(a), fprc(prc){};

};


struct PamVMCMat : public TObject {
  Int_t fid;
  Double_t fa, fz, frho;

  PamVMCMat():fa(0.),fz(0.),frho(0.) {};
  PamVMCMat(Int_t id, Double_t a, Double_t z, Double_t rho): fid(id),fa(a),fz(z),frho(rho){};

};

struct PamVMCMix : public PamVMCMat{
  Int_t fnum; //number of elements
  TObjArray felements; //array of of elements

  void AddElement(Int_t z, Double_t a, Double_t prc){

    felements.Add(new PamVMCElem(z,a,prc));

  }

};


struct PamVMCMed : public TObject {
  Int_t fnumed, fimat, fisvol, fifield;
  Double_t ffieldm, ftmaxfd, fstemax, fdeemax, fepsil, fstmin;

  PamVMCMed():fnumed(0),fimat(0),fisvol(0),fifield(0),ffieldm(0.),
              ftmaxfd(0.),fstemax(0.),fdeemax(0.), fepsil(0.), fstmin(0.){};

  PamVMCMed(Int_t numed, Int_t imat, Int_t isvol, Int_t ifield, 
	    Double_t fieldm, Double_t tmaxfd, Double_t stemax,
	    Double_t deemax, Double_t epsil, Double_t stmin): 
            fnumed(numed), fimat(imat), fisvol(isvol), fifield(ifield),
            ffieldm(fieldm), ftmaxfd(tmaxfd), fstemax(stemax), fdeemax(deemax),
            fepsil(epsil), fstmin(stmin){};

};

#endif //PAM_VMC_MAT
