
// $Id: PamVMCApplication.h,v 1.0 2007/06/01
// 
// Class PamVMCApplication
// ----------------------- 
// Implementation of the TVirtualMCApplication


#ifndef PAMVMC_APPLICATION_H
#define PAMVMC_APPLICATION_H

#include <TVirtualMCApplication.h>
#include <TMCVerbose.h>
#include <TRandom.h>

#include "PamVMCDetectorSD.h"

#include "PamVMCPrimaryGenerator.h"
#include "PamVMCDetector.h"
#include "PamVMCDetPamela.h"
#include "PamVMCFieldMgr.h"

#include "PamRootManager.h"
#include "PamVMCDetectorHit.h"
#include <TMap.h>


#ifdef PAMFIELD
#include "TrkParams.h"
#endif

//class PamVMCDetector;

class PamVMCStack;
//class PamVMCDetectorConstruction;
class PamVMCPrimaryGenerator;


class PamVMCDetPamela;

class PamVMCApplication : public TVirtualMCApplication
{
  public:
    PamVMCApplication(const char* name,  const char *title, const char* filename="pamtest", Int_t seed=0);
 
    virtual ~PamVMCApplication();
  
    // static access method
    static PamVMCApplication* Instance();
 
    // methods
    void SetRandom(const char *dname, TRandom3* random){
      PamVMCDigMgr::Instance()->SetRandom(dname,random);
    }
    
    Int_t GetTrigger(){ return ftrig; }

    void InitMC(const char *setup);
    void RunMC(Int_t nofEvents);
    void AddIons();
    
    void FillEv();

    virtual void ConstructGeometry();
    virtual void InitGeometry();
    virtual void GeneratePrimaries();
    virtual void BeginEvent();
    virtual void BeginPrimary();
    virtual void PreTrack();
    virtual void Stepping();
    virtual void PostTrack();
    virtual void FinishPrimary();
    virtual void FinishEvent();
    virtual void FinishRun();
#if ROOT_VERSION_CODE < 333572
    virtual void Field(const Double_t* x, Double_t* b) const;
#endif
    // set methods
    void  SetVerboseLevel(Int_t verboseLevel);
 
    // get methods
    PamVMCPrimaryGenerator*  GetPrimaryGenerator() const;

 
 
  private:

    // data members
    Int_t                     fEventNo;
    TMCVerbose                fVerbose;
    PamVMCStack*              fStack;
    PamVMCDetPamela*          fdetector;
    PamVMCPrimaryGenerator*   fPrimaryGenerator;
    PamRootManager            fRootManager;
    TRandom3*                 frandom;
    fin                       fdstatus;
    Int_t                     ftrig;
  

  


#ifdef PAMFIELD
    //    TrkLevel2 pamfield;
#endif
  ClassDef(PamVMCApplication,1)  //Interface to MonteCarlo application
};

// inline functions

inline PamVMCApplication* PamVMCApplication::Instance()
{ return (PamVMCApplication*)(TVirtualMCApplication::Instance()); }

inline void  PamVMCApplication::SetVerboseLevel(Int_t verboseLevel)
{ fVerbose.SetLevel(verboseLevel); }

inline PamVMCPrimaryGenerator*  PamVMCApplication::GetPrimaryGenerator() const
{ return fPrimaryGenerator; }



#endif //PAMVMC_APPLICATION_H

