#ifndef PCUTCONTROL_H
#define PCUTCONTROL_H

#include <TObject.h>
#include <iostream>
#include <TVirtualMC.h>
#include <TGeoManager.h>
#include <TList.h>
 
class pCutControl : public TObject {
  
  private:

  Int_t fid; // medium id
  Int_t fid_m ; //medium id in GeoManager

  Double_t fCUTGAM, fBCUTE, fCUTELE, fDCUTE, fCUTNEU,
    fCUTHAD, fCUTMUO, fDCUTM, fBCUTM, fPPCUTM, fPAIR,
    fCOMP, fPHOT, fPFIS, fDRAY, fANNI, fBREM, fHADR,
    fMUNU, fDCAY, fLOSS, fMULS;

  public:  

  pCutControl():
       fid(-1), // must be overwriten for specific media
       fCUTGAM(0.001), 
       fBCUTE(0.001), 
       fCUTELE(0.001), 
       fDCUTE(10000.), 
       fCUTNEU(0.01),
       fCUTHAD(0.01), 
       fCUTMUO(0.01), 
       fDCUTM(10000.), 
       fBCUTM(0.001), 
       fPPCUTM(0.01), 
       fPAIR(1.),
       fCOMP(1.), 
       fPHOT(1.), 
       fPFIS(0.), 
       fDRAY(1.), 
       fANNI(1.), 
       fBREM(1.), 
       fHADR(1.),
       fMUNU(1.), 
       fDCAY(1.), 
       fLOSS(1.), 
       fMULS(1.)
	 {
	   fid_m = FindMedia();
	 }; 
  
  virtual ~pCutControl(){; };

  pCutControl(Int_t id,
              Double_t CUTGAM, Double_t BCUTE, Double_t CUTELE, Double_t DCUTE, 
              Double_t CUTNEU, Double_t CUTHAD, Double_t CUTMUO, Double_t DCUTM, 
	      Double_t BCUTM, Double_t PPCUTM, Double_t PAIR, Double_t COMP, 
	      Double_t PHOT,  Double_t PFIS, Double_t DRAY, Double_t ANNI, Double_t BREM, 
              Double_t HADR, Double_t MUNU, Double_t DCAY, Double_t LOSS, Double_t MULS):
       fid(id),
       fCUTGAM(CUTGAM),
       fBCUTE(BCUTE),
       fCUTELE(CUTELE),
       fDCUTE(DCUTE),
       fCUTNEU(CUTNEU),
       fCUTHAD(CUTHAD),
       fCUTMUO(CUTMUO),
       fDCUTM(DCUTM),
       fBCUTM(BCUTM),
       fPPCUTM(PPCUTM),
       fPAIR(PAIR),
       fCOMP(COMP),
       fPHOT(PHOT),
       fPFIS(PFIS),
       fDRAY(DRAY),
       fANNI(ANNI),
       fBREM(BREM),
       fHADR(HADR),
       fMUNU(MUNU),
       fDCAY(DCAY),
       fLOSS(LOSS),
       fMULS(MULS) 
	 {
	    fid_m = FindMedia();
	 };

  Int_t GetID(){ return fid; };
  Double_t GetCUTGAM(){ return fCUTGAM; };
  Double_t GetBCUTE(){ return fBCUTE; };
  Double_t GetCUTELE(){ return fCUTELE; };
  Double_t GetDCUTE(){ return fDCUTE; };
  Double_t GetCUTNEU(){ return fCUTNEU; };
  Double_t GetCUTHAD(){ return fCUTHAD; };
  Double_t GetCUTMUO(){ return fCUTMUO; };
  Double_t GetDCUTM(){ return fDCUTM; }
  Double_t GetBCUTM(){ return fBCUTM; }
  Double_t GetPPCUTM(){ return fPPCUTM; }
  Double_t GetPAIR(){ return fPAIR; }
  Double_t GetCOMP(){ return fCOMP; }
  Double_t GetPHOT(){ return fPHOT; }
  Double_t GetPFIS(){ return fPFIS; }
  Double_t GetDRAY(){ return fDRAY; }
  Double_t GetANNI(){ return fANNI; }
  Double_t GetBREM(){ return fBREM; }
  Double_t GetHADR(){ return fHADR; }
  Double_t GetMUNU(){ return fMUNU; }
  Double_t GetDCAY(){ return fDCAY; }
  Double_t GetLOSS(){ return fLOSS; }
  Double_t GetMULS(){ return fMULS; }


  void SetID(Int_t id){ fid = id; };
  void SetCUTGAM(Double_t CUTGAM){ fCUTGAM = CUTGAM; };
  void SetBCUTE(Double_t BCUTE ){ fBCUTE = BCUTE; };
  void SetCUTELE(Double_t CUTELE){ fCUTELE = CUTELE; };
  void SetDCUTE(Double_t DCUTE){ fDCUTE = DCUTE; };
  void SetCUTNEU(Double_t CUTNEU){ fCUTNEU = CUTNEU; };
  void SetCUTHAD(Double_t CUTHAD){ fCUTHAD = CUTHAD; };
  void SetCUTMUO(Double_t CUTMUO){ fCUTMUO = CUTMUO; };
  void SetDCUTM(Double_t DCUTM){ fDCUTM = DCUTM; }
  void SetBCUTM(Double_t BCUTM){ fBCUTM = BCUTM; }
  void SetPPCUTM(Double_t PPCUTM){ fPPCUTM = PPCUTM; }
  void SetPAIR(Double_t PAIR){ fPAIR = PAIR; }
  void SetCOMP(Double_t COMP){ fCOMP = COMP; }
  void SetPHOT(Double_t PHOT){ fPHOT = PHOT; }
  void SetPFIS(Double_t PFIS){ fPFIS = PFIS; }
  void SetDRAY(Double_t DRAY){ fDRAY = DRAY; }
  void SetANNI(Double_t ANNI){ fANNI = ANNI; }
  void SetBREM(Double_t BREM){ fBREM = BREM; }
  void SetHADR(Double_t HADR){ fHADR = HADR; }
  void SetMUNU(Double_t MUNU){ fMUNU = MUNU; }
  void SetDCAY(Double_t DCAY){ fDCAY = DCAY; }
  void SetLOSS(Double_t LOSS){ fLOSS = LOSS; }
  void SetMULS(Double_t MULS){ fMULS = MULS; }

  Int_t FindMedia(){
    if(gGeoManager){
      TList* ls = gGeoManager->GetListOfMedia();
      for(Int_t i = 0; i<ls->GetEntries(); i++){
	if( ((TGeoMedium*)ls->At(i))->GetId() == fid ) return i+1;
      }
    }
    return 0;
  }

  void SetCuts(){
    

     gMC->Gstpar(fid_m,"CUTGAM",fCUTGAM);
     gMC->Gstpar(fid_m,"BCUTE",fBCUTE);
     gMC->Gstpar(fid_m,"CUTELE",fCUTELE);
     gMC->Gstpar(fid_m,"DCUTE",fDCUTE);
     gMC->Gstpar(fid_m,"CUTNEU",fCUTNEU);
     gMC->Gstpar(fid_m,"CUTHAD",fCUTHAD);
     gMC->Gstpar(fid_m,"CUTMUO",fCUTMUO);
     gMC->Gstpar(fid_m,"DCUTM",fDCUTM);
     gMC->Gstpar(fid_m,"BCUTM",fBCUTM);
     gMC->Gstpar(fid_m,"PPCUTM",fPPCUTM);
     gMC->Gstpar(fid_m,"PAIR",fPAIR);
     gMC->Gstpar(fid_m,"COMP",fCOMP);
     gMC->Gstpar(fid_m,"PHOT",fPHOT);
     gMC->Gstpar(fid_m,"PFIS",fPFIS);
     gMC->Gstpar(fid_m,"DRAY",fDRAY);
     gMC->Gstpar(fid_m,"ANNI",fANNI);
     gMC->Gstpar(fid_m,"BREM",fBREM);
     gMC->Gstpar(fid_m,"HADR",fHADR);
     gMC->Gstpar(fid_m,"MUNU",fMUNU);
     gMC->Gstpar(fid_m,"DCAY",fDCAY);
     gMC->Gstpar(fid_m,"LOSS",fLOSS);
     gMC->Gstpar(fid_m,"MULS",fMULS);
  }  

  void Print(const Option_t* ="") const{
    std::cout<<"ID: "<<fid_m<<std::endl;
    std::cout<<"CUTGAM: "<<fCUTGAM<<std::endl;
    std::cout<<"BCUTE: "<<fBCUTE<<std::endl;
    std::cout<<"DCUTE: "<<fDCUTE<<std::endl;
    std::cout<<"CUTNEU: "<<fCUTNEU<<std::endl;
    std::cout<<"CUTHAD: "<<fCUTHAD<<std::endl;
    std::cout<<"CUTMUO: "<<fCUTMUO<<std::endl;
    std::cout<<"DCUTM: "<<fDCUTM<<std::endl;
    std::cout<<"BCUTM: "<<fBCUTM<<std::endl;
    std::cout<<"PPCUTM: "<<fPPCUTM<<std::endl;
    std::cout<<"PAIR: "<<fPAIR<<std::endl;
    std::cout<<"COMP: "<<fCOMP<<std::endl;
    std::cout<<"PHOT: "<<fPHOT<<std::endl;
    std::cout<<"PFIS: "<<fPFIS<<std::endl;
    std::cout<<"DRAY: "<<fDRAY<<std::endl;
    std::cout<<"ANNI: "<<fANNI<<std::endl;
    std::cout<<"BREM: "<<fBREM<<std::endl;
    std::cout<<"HADR: "<<fHADR<<std::endl;
    std::cout<<"MUNU: "<<fMUNU<<std::endl;
    std::cout<<"DCAY: "<<fDCAY<<std::endl;
    std::cout<<"LOSS: "<<fLOSS<<std::endl;
    std::cout<<"MULS: "<<fMULS<<std::endl;
   }
   ClassDef(pCutControl,1)

};



#endif //PCUTCONTROL
