#ifndef PAMVMC_DET_PAMELA_H
#define PAMVMC_DET_PAMELA_H

#include "PamVMCDetector.h"

#include "PamVMCDetCalo.h"
#include "PamVMCDetTrk.h"
#include "PamVMCDetTof.h"
#include "PamVMCDetAc.h"
#include "PamVMCDetS4.h"
#include "PamVMCDetND.h"
#include "PamVMCOptMgr.h"



class PamVMCDetPamela  : public PamVMCDetector {

 private:


 public:

   PamVMCDetPamela():PamVMCDetector("Pamela") 
  {
    PamVMCOptMgr* omg = PamVMCOptMgr::Instance();

    TString t;
    if(! omg->IsNoCalo() ){
      t = "Calorimeter";
      fsubdet.Add(new TObjString(t), new PamVMCDetCalo());
    } else { 
      cout << "Skipping Calorimeter Construction" << endl; 
    }
    t = "Tracker";
    fsubdet.Add(new TObjString(t), new PamVMCDetTrk());
    t = "Tof";
    fsubdet.Add(new TObjString(t), new PamVMCDetTof());
    t = "Ac";
    fsubdet.Add(new TObjString(t), new PamVMCDetAc()); 
    t = "S4";
    fsubdet.Add(new TObjString(t), new PamVMCDetS4());   
    t = "ND";
    fsubdet.Add(new TObjString(t), new PamVMCDetND()); 

  };

   void DefineMother();

   void DefineShell();

   void DefineCuts();
  
   //void SetCuts();

   void DefineGeometry(){
     DefineMother();
     DefineShell();
   }

   TGeoVolume* GetMotherVol(){ return GetVol("PAME"); }

  

  ClassDef(PamVMCDetPamela,1)
};


#endif //PAMVMC_DET_PAMELA_H
