// $Id: g4Config.C,v 1.5 2009-06-12 18:39:13 pam-rm2 Exp $
//
// Configuration macro for Geant4 VirtualMC for PamG4VMC
// for geometry defined with Root and selected Geant4 native navigation

void Config()
{
  
  gSystem->Load("libG4phys_builders");
  gSystem->Load("libG4phys_lists");

  TString PAM_VMC=gSystem->Getenv("PAM_VMC");
  TString PLAT=gSystem->Getenv("PLATFORM");

  gSystem->Load(PAM_VMC+"/lib/tgt_"+PLAT+"/libPamG4RunConfiguration");
  //  std::cout<<PAM_VMC+"/lib/tgt_"+PLAT+"/libPamG4RunConfiguration";
  PamG4RunConfiguration* runConfiguration 
    = new PamG4RunConfiguration("geomRoot","QGSP_BIC_HP");

  TGeant4* geant4
    = new TGeant4("TGeant4_PAMELA", "The Geant4 PAMELA Monte Carlo", runConfiguration);
 
  geant4->ProcessGeantMacro(PAM_VMC+"/config/g4config_em.in");

}
