#ifndef VK_MASK_PAMCUT
#define VK_MASK_PAMCUT

#define NPLN 12
#define NLAD 3
#define NVKL 8

#include <iostream>
#include <TObject.h>
using std::cout;
using std::endl;

class VKmask : public TObject
{
  UInt_t fvk_mask [NPLN];

 public:

  VKmask(){
    for(Int_t j = 0; j<NPLN; j++) fvk_mask[j] = 16777215; //full-mask
  }

  VKmask( UInt_t msk[NPLN] ){
    for(Int_t j = 0; j<NPLN; j++) SetMaskRow(j,msk[j]); 
  }
  
  
  virtual ~VKmask(){;}
  virtual void Clear(Option_t * = ""){ this->~VKmask(); }

  UInt_t GetMaskRow(Int_t j) const { return fvk_mask[j]; }
  Bool_t GetMaskBool(Int_t iv, Int_t ivk){
    Int_t whichbit = (Int_t)pow(2,ivk);
    return (whichbit&fvk_mask[iv]) != 0;
  }
  void GetMaskBool( Bool_t ***vk_matrix ){
    for(Int_t v = 1; v<NPLN+1; v++){
      for(Int_t jl = 1; jl < NLAD+1; jl++){
	for(Int_t iv = 1; iv < NVKL+1; iv++){
	  Int_t ivk = (jl-1)*NVKL+iv-1;
	  Int_t whichbit = (Int_t)pow(2,ivk);
	  Bool_t val = ((whichbit&fvk_mask[v-1])!=0);
	  vk_matrix[v-1][jl-1][iv-1] = val;
	}
      }
    }
  }
  void SetMaskRow(Int_t j, UInt_t val){ 
    fvk_mask[j] = val;
  };
 

 inline Bool_t operator==(const VKmask& other) const {
    for(Int_t j = 0; j<NPLN; j++) 
      if( fvk_mask[j] != other.GetMaskRow(j)) return kFALSE;
    return kTRUE;
  }

 ClassDef(VKmask,1);

};



#endif //VK_MASK_PAMCUT
