#include <TMath.h>
#include "PamVMCDetCard.h"

ClassImp(PamVMCDetCard)

using TMath::Tan;
using TMath::ATan;
using TMath::Sin;
using TMath::Cos;
using TMath::Pi;

void  PamVMCDetCard::DefineGeometry(){

  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID( 9);
  }

  s = "IRON";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,55.85,26,7.87);
    m->SetUniqueID( 10);    
  }

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID( 17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID( 19);
  }

  s = "PLAST";
  x = (TGeoMixture*)GetMat(s);
   if(!x){
     x = new TGeoMixture(s,2,   1.03200    );
     x->SetUniqueID( 28);
     x->DefineElement(0,12.01,6,0.9929774);
     x->DefineElement(1,1.01,1,0.7022570E-02);
   }

   TGeoMedium *n =0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "PLASTIC";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,18,28,-1,1,40,1,100,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "IRON";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,27,10,-1,1,40,1,100,0.5000000E-01,0.2491200E-02,0.5000000E-03);


  TGeoVolume *v = 0;

  Double_t H1=6.6;
  Double_t H2=11.55;
  Double_t B1=20.95+3.6+5.8+H1/Tan(76./180.*Pi());
  Double_t C1=H2/Tan(76./180.*Pi());
  Double_t A1=37.18273-C1;
  Double_t D1=37.18273-20.95-3.6-5.8;
  Double_t ANG=ATan((B1/2.+D1-A1/2.)/18.15)/Pi()*180.;
  
  Double_t B2=17.45+3.6+5.8+H1/Tan(76./180.*Pi());
  Double_t C2=H2/Tan(76./180.*Pi());
  Double_t A2=31.98273-C2;
  Double_t D2=31.98273-17.45-3.6-5.8;
  Double_t ANG2=ATan((B2/2.+D2-A2/2.)/18.15)/Pi()*180.;


  Double_t BB=B1/2.+1.1*(1./Cos(ATan(D1/18.15))-D1/18.15+1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  Double_t AA=A1/2.+1.1*(1./Cos(ATan(D1/18.15))+D1/18.15-1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  Double_t DD=10.175*2.*D1/18.15;
  Double_t CAR1_2=-ATan((BB+DD-AA)/(2.*10.175))/Pi()*180.;
  Double_t CAR1_9=BB;
  Double_t C1D1_9=B1/2.;
  Double_t C2D1_9=B2/2.;

  s = "C1D1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap(s,GetMed("SCINTILLATOR"),9.075,-ANG,0.,0.4,A1/2.,A1/2.,0.,0.4,C1D1_9,C1D1_9,0.);



  s = "C2D1";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrap(s,GetMed("SCINTILLATOR"),9.075,-ANG2,0.,0.4,A2/2.,A2/2.,0.,0.4,C2D1_9,C2D1_9,0.);
 

  s = "CAR1";
  v = (GetVol(s))?GetVol(s):gGeoManager->MakeTrap(s,GetMed("ALUMINIUM"),10.175,CAR1_2,0.,0.55,AA,AA,0.,0.55,CAR1_9,CAR1_9,0.);


  BB=B1/2.+0.9*(1./Cos(ATan(D1/18.15))-D1/18.15+1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  AA=A1/2.+0.9*(1./Cos(ATan(D1/18.15))+D1/18.15-1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  DD=9.975*2.*D1/18.15;
  Double_t CR1P_2=-ATan((BB+DD-AA)/(2.*9.975))/Pi()*180.;
  Double_t CR1P_9=BB;
  
  s = "CR1P";
  v = (GetVol(s))?GetVol(s):gGeoManager->MakeTrap(s,GetMed("PLASTIC"),9.975,CR1P_2,0.,0.4,AA,AA,0.,0.4,CR1P_9,CR1P_9,0.);

  //===========//

  BB=B2/2.+1.1*(1./Cos(ATan(D2/18.15))-D2/18.15+1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  AA=A2/2.+1.1*(1./Cos(ATan(D2/18.15))+D2/18.15-1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  DD=10.175*2.*D2/18.15;
  Double_t CAR2_2=-ATan((BB+DD-AA)/(2.*10.175))/Pi()*180.;
  Double_t CAR2_9=BB;

  s = "CAR2";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("ALUMINIUM"),10.175,CAR2_2,0.,0.55,AA,AA,0.,0.55,CAR2_9,CAR2_9,0.);
 
  //==========//

  BB=B2/2.+0.9*(1./Cos(ATan(D2/18.15))-D2/18.15+1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  AA=A2/2.+0.9*(1./Cos(ATan(D2/18.15))+D2/18.15-1./Tan(76./180.*Pi())+1./Sin(76./180.*Pi()))/2.;
  DD=9.975*2.*D2/18.15;
  Double_t CR2P_2=-ATan((BB+DD-AA)/(2.*9.975))/Pi()*180.;
  Double_t CR2P_9=BB;
 
  s = "CR2P";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("PLASTIC"),9.975,CR2P_2,0.,0.4,AA,AA,0.,0.4,CR2P_9,CR2P_9,0.);

  //==========//

  AA=4.8+1.8;
  BB=AA/Tan(76./180.*Pi())+AA*3.6/4.8;
  Double_t VSN1_2=ATan((BB/2.-AA/Tan(76./180.*Pi()))/AA)/Pi()*180.;
  Double_t VSN1_9=BB/2.;

  s = "VSN1";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),3.3,VSN1_2,0.,0.4,0.,0.,0.,0.4,VSN1_9,VSN1_9,0.);

  //==========//

  AA=1.8;
  BB=AA*(5.8/1.8-3.6/4.8);
  Double_t VSN2_1=0.9;
  Double_t VSN2_2=ATan((BB/2.+AA*3.6/4.8)/AA)/Pi()*180.;
  Double_t VSN2_9=2.225;

  s = "VSN2";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("PLASTIC"),VSN2_1,VSN2_2,0.,0.4,0.,0.,0.,0.4,VSN2_9,VSN2_9,0.);

  //=========//

  AA=1.8+0.9-Cos(ATan(3.6/4.8))*0.9/Sin(ATan(5.8/1.8)-ATan(3.6/4.8));
  BB=AA*(5.8/1.8-3.6/4.8);
  Double_t VPN2_1=AA/2.;
  Double_t VPN2_2=ATan((BB/2.+AA*3.6/4.8)/AA)/Pi()*180.;
  Double_t VPN2_9=BB/2.;


  s = "VPN2";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("ALUMINIUM"),VPN2_1,VPN2_2,0.,/*0.55*/ 0.4,0.,0.,0.,/*0.55*/0.4,VPN2_9,VPN2_9,0.);

  //=========//

  AA=(0.9/Sin(76./180.*Pi()))/(1./Tan(76./180.*Pi())+3.6/4.8)+4.8+1.8+0.9;
  BB=AA/Tan(76./180.*Pi())+AA*3.6/4.8;
  Double_t VPN1_1=AA/2.;
  Double_t VPN1_9=BB/2.;

  s = "VPN1";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),VPN1_1,VSN1_2,0.,0.4,0.,0.,0.,0.4,VPN1_9,VPN1_9,0.);

  //=========//

  AA=(1.1/Sin(76./180.*Pi()))/(1./Tan(76./180.*Pi())+3.6/4.8)+4.8+1.8+1.1;
  Double_t VAN1_1=AA/2.;
  BB=AA/Tan(76./180.*Pi())+AA*3.6/4.8;
  Double_t VAN1_9=BB/2.;

  s = "VAN1";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),VAN1_1,VSN1_2,0.,0.55,0.,0.,0.,0.55,VAN1_9,VAN1_9,0.);

  //=========//

  AA=1.8+1.1-Cos(ATan(3.6/4.8))*1.1/Sin(ATan(5.8/1.8)-ATan(3.6/4.8));
  BB=AA*(5.8/1.8-3.6/4.8);
  Double_t VAN2_1=AA/2.;
  Double_t VAN2_2=ATan((BB/2.+AA*3.6/4.8)/AA)/Pi()*180.;
  Double_t VAN2_9=BB/2.;

  s = "VAN2";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),VAN2_1,VAN2_2,0.,0.55,0.,0.,0.,0.55,VAN2_9,VAN2_9,0.);

  //=========//

  s = "CARD";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),27.,22.8,12.35);
  s = "LEGB";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),2.15,3.575,11.85);
  s = "LEG1";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),0.65,0.,0.,0.15,6.85,6.85,0.,0.15,10.85,10.85,0.);
  s = "LEG2";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),0.65,1.65,11.35);
  s = "LEG3";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),0.1,1.3,0.325);
  s = "LEG4";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),0.65,1.625,11.85);
  s = "LEG5";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.125,2.575,11.85);
  s = "LEG6";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),0.1,0.55,11.2);
  s = "LEG7";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.1,0.75,3.25);
  s = "LEG8";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.1,0.75,4.35);
  s = "LEG9";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.1,0.75,3.25);
  s = "TPLT";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),27.,22.8,0.5);
  s = "TOPC";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),20.4,16.,0.5);
  s = "TH11";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),2.8,3.2,0.5);
  s = "TH12";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),2.8,5.3,0.5);
  s = "TH21";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),1.7,3.,0.5);
  s = "TH22";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),4.9,3.,0.5);
  s = "TOPT";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTrap(s,GetMed("N2 GAS"),0.5,0.,0.,2.25,2.25,0.,-26.565,2.25,2.25,0.,-26.565);
  s = "TOHO";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeTube(s,GetMed("N2 GAS"),0.,0.7,0.5);
  s = "MGSC";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("IRON"),16.,15.4,0.12456);
  s = "MGSH";
  v = (GetVol(s))?GetVol(s):  gGeoManager->MakeBox(s,GetMed("N2 GAS"),9.8,8.,0.12456);


  Double_t X,Y,Z;
  Double_t X1,Y1,Z1,X2,Y2,Z2;
  Double_t ZH=49.229-(13.05+10.639+2.97+2.*22.615+1.6)-1.6;

  Y=-16.014+19.45/2.*Sin(17./180.*Pi());
  Z=47.661+ZH-12.35-19.45*Cos(17./180.*Pi())/2.;
  X=((35.6/2.)-Tan(ANG/180.*Pi())*19.45/2.)-18.67;
  X1=X; Y1=Y; Z1=Z;
  GetVol("CARD")->AddNode(GetVol("CAR1"),1,new TGeoCombiTrans(X1,Y1,Z1,GetRot("rot11")));
    Z=10.175-VAN1_1;
    X=-(CAR1_9-10.175*Tan(CAR1_2/180.*Pi())-(VAN1_9-VAN1_1*Tan(VSN1_2/180.*Pi())));
    GetVol("CAR1")->AddNode(GetVol("VAN1"),1,new TGeoTranslation(X,0.,Z));//many
    Z=10.175-VAN2_1;
    X=-(CAR1_9-10.175*Tan(CAR1_2/180.*Pi())-(2.*VAN1_9+VAN2_9-VAN2_1*Tan(VAN2_2/180.*Pi())));
    GetVol("CAR1")->AddNode(GetVol("VAN2"),1,new TGeoTranslation(X,0.,Z));//many
    X=(1.1-0.9)*(1./Cos(ATan(D1/18.15))-1./Sin(76./180.*Pi()))/2.;
    GetVol("CAR1")->AddNodeOverlap(GetVol("CR1P"),1,new TGeoTranslation(X,0.,0.));//only
      Z=9.975-VPN1_1;
      X=-(CR1P_9-9.975*Tan(CR1P_2/180.*Pi())-(VPN1_9-VPN1_1*Tan(VSN1_2/180.*Pi())));
      GetVol("CR1P")->AddNode(GetVol("VPN1"),1,new TGeoTranslation(X,0.,Z)); //many
      Z=9.975-VPN2_1;
      X=-(CR1P_9-9.975*Tan(CR1P_2/180.*Pi())-(2.*VPN1_9+VPN2_9-VPN2_1*Tan(VPN2_2/180.*Pi())));
      GetVol("CR1P")->AddNode(GetVol("VPN2"),1,new TGeoTranslation(X,0.,Z));//many
      X=0.9*(1./Cos(ATan(D1/18.15))-1./Sin(76./180.*Pi()))/2.;
      GetVol("CR1P")->AddNodeOverlap(GetVol("C1D1"),1,new TGeoTranslation(X,0.,0.));//only
        X=-(C1D1_9+9.075*Tan(ANG/180.*Pi())-(VSN1_9-3.3*Tan(VSN1_2/180.*Pi())));
        GetVol("C1D1")->AddNode(GetVol("VSN1"),1,new TGeoTranslation(X,0.,5.775)); //only
        X=-(C1D1_9+9.075*Tan(ANG/180.*Pi())-(2.*VSN1_9+2.225-0.9*Tan(VSN2_2/180.*Pi()))); 
        GetVol("C1D1")->AddNode(GetVol("VSN2"),1,new TGeoTranslation(X,0.,8.175)); //only


  GetVol("CARD")->AddNode(GetVol("CAR1"),2,new TGeoCombiTrans(-X1,-Y1,Z1,GetRot("rot12")));

  X=19.123-19.45/2.*Sin(20./180.*Pi());
  Z=47.358+ZH-12.35-19.45*Cos(20./180.*Pi())/2.;
  Y=(30.4/2.-Tan(ANG2/180.*Pi())*19.45/2.)-16.8;
  X2=X; Y2=Y; Z2=Z;

  GetVol("CARD")->AddNode(GetVol("CAR2"),1,new TGeoCombiTrans(X2,Y2,Z2,GetRot("rot14")));

     Z=10.175-VAN1_1;
     X=-(CAR2_9-10.175*Tan(CAR2_2/180.*Pi())-(VAN1_9-VAN1_1*Tan(VSN1_2/180.*Pi())));
     GetVol("CAR2")->AddNode(GetVol("VAN1"),2,new TGeoTranslation(X,0.,Z)); //many
     Z=10.175-VAN2_1;
     X=-(CAR2_9-10.175*Tan(CAR2_2/180.*Pi())-(2.*VAN1_9+VAN2_9-VAN2_1*Tan(VAN2_2/180.*Pi())));
     GetVol("CAR2")->AddNode(GetVol("VAN2"),2,new TGeoTranslation(X,0.,Z)); //many
     X=(1.1-0.9)*(1./Cos(ATan(D2/18.15))-1./Sin(76./180.*Pi()))/2.;     
     GetVol("CAR2")->AddNodeOverlap(GetVol("CR2P"),1,new TGeoTranslation(X,0.,0.)); // only
        Z=9.975-VPN1_1;
        X=-(CR2P_9+9.975*Tan(ANG2/180.*Pi())-(VPN1_9-VPN1_1*Tan(VSN1_2/180.*Pi())));
        GetVol("CR2P")->AddNode(GetVol("VPN1"),2,new TGeoTranslation(X,0.,Z)); //many
	Z=9.975-VPN2_1;
	X=-(CR2P_9-9.975*Tan(CR2P_2/180.*Pi())-(2.*VPN1_9+VPN2_9-VPN2_1*Tan(VPN2_2/180.*Pi())));
        GetVol("CR2P")->AddNode(GetVol("VPN2"),2,new TGeoTranslation(X,0.,Z));//many
	X=0.9*(1./Cos(ATan(D2/18.15))-1./Sin(76./180.*Pi()))/2.;
        GetVol("CR2P")->AddNodeOverlap(GetVol("C2D1"),1,new TGeoTranslation(X,0.,0.));//only
	  Z=9.075-3.3;
	  X=-(C2D1_9+9.075*Tan(ANG2/180.*Pi())-(VSN1_9-3.3*Tan(VSN1_2/180.*Pi())));
          GetVol("C2D1")->AddNode(GetVol("VSN1"),2,new TGeoTranslation(X,0.,Z)); //only
          Z=9.075-0.9;
	  X=-(C2D1_9+9.075*Tan(ANG2/180.*Pi())-(2.*VSN1_9+VSN2_9-VSN2_1*Tan(VSN2_2/180.*Pi())));
          GetVol("C2D1")->AddNode(GetVol("VSN2"),2,new TGeoTranslation(X,0.,Z)); //only

  GetVol("CARD")->AddNode(GetVol("CAR2"),2,new TGeoCombiTrans(-X2,-Y2,Z2,GetRot("rot13")));

	//==Checked==// 

  GetVol("CARD")->AddNode(GetVol("LEGB"),1,new TGeoTranslation(-22.9,-18.575,-0.5));
      GetVol("LEGB")->AddNode(GetVol("LEG1"),1,new TGeoCombiTrans(-1.5,-3.425,0.,GetRot("rot7")));
      GetVol("LEGB")->AddNode(GetVol("LEG1"),2,new TGeoCombiTrans(-1.5,0.175,0.,GetRot("rot7")));
      GetVol("LEGB")->AddNode(GetVol("LEG2"),1,new TGeoTranslation(-1.5,-1.625,0.));
      GetVol("LEGB")->AddNode(GetVol("LEG3"),1,new TGeoTranslation(-0.55,2.275,11.525));
      GetVol("LEGB")->AddNode(GetVol("LEG3"),2,new TGeoTranslation(-0.55,2.275,-11.525));
      GetVol("LEGB")->AddNode(GetVol("LEG4"),1,new TGeoTranslation(-1.5,1.95,0.));
      GetVol("LEGB")->AddNode(GetVol("LEG5"),1,new TGeoTranslation(1.025,1.,0.));
      GetVol("LEGB")->AddNode(GetVol("LEG6"),1,new TGeoTranslation(-0.75,3.025,0.));
      GetVol("LEGB")->AddNode(GetVol("LEG7"),1,new TGeoTranslation(0.65,-2.825,8.));
      GetVol("LEGB")->AddNode(GetVol("LEG8"),1,new TGeoTranslation(0.65,-2.825,0.));
      GetVol("LEGB")->AddNode(GetVol("LEG9"),1,new TGeoTranslation(0.65,-2.825,-8.));
  GetVol("CARD")->AddNode(GetVol("LEGB"),2,new TGeoCombiTrans(-22.9,18.575,-0.5,GetRot("rot10")));
  GetVol("CARD")->AddNode(GetVol("LEGB"),3,new TGeoCombiTrans(22.9,18.575,-0.5,GetRot("rot4")));
  GetVol("CARD")->AddNode(GetVol("LEGB"),4,new TGeoCombiTrans(22.9,-18.575,-0.5,GetRot("rot9")));
  GetVol("CARD")->AddNode(GetVol("TPLT"),1,new TGeoTranslation(0.,0.,11.85));
    GetVol("TPLT")->AddNode(GetVol("TOPC"),1,gGeoIdentity);
    GetVol("TPLT")->AddNode(GetVol("TH11"),1,new TGeoTranslation(-23.6,14.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH11"),2,new TGeoTranslation(-23.6,-14.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH11"),3,new TGeoTranslation(23.6,14.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH11"),4,new TGeoTranslation(23.6,-14.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH12"),1,new TGeoTranslation(-23.6,5.5,0.));
    GetVol("TPLT")->AddNode(GetVol("TH12"),2,new TGeoTranslation(-23.6,-5.5,0.));
    GetVol("TPLT")->AddNode(GetVol("TH12"),3,new TGeoTranslation(23.6,5.5,0.));
    GetVol("TPLT")->AddNode(GetVol("TH12"),4,new TGeoTranslation(23.6,-5.5,0.));
    GetVol("TPLT")->AddNode(GetVol("TH21"),1,new TGeoTranslation(-17.2,19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH21"),2,new TGeoTranslation(-17.2,-19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH21"),3,new TGeoTranslation(17.2,19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH21"),4,new TGeoTranslation(17.2,-19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),1,new TGeoTranslation(-10.2,19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),2,new TGeoTranslation(-10.2,-19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),3,new TGeoTranslation(10.2,19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),4,new TGeoTranslation(10.2,-19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),5,new TGeoTranslation(0.,19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TH22"),6,new TGeoTranslation(0.,-19.4,0.));
    GetVol("TPLT")->AddNode(GetVol("TOPT"),1,new TGeoTranslation(-25.875,-20.55,0.));
    GetVol("TPLT")->AddNode(GetVol("TOPT"),2,new TGeoCombiTrans(-25.875,20.55,0.,GetRot("rot10")));
    GetVol("TPLT")->AddNode(GetVol("TOPT"),3,new TGeoCombiTrans(25.875,20.55,0.,GetRot("rot4")));
    GetVol("TPLT")->AddNode(GetVol("TOPT"),4,new TGeoCombiTrans(25.875,-20.55,0.,GetRot("rot9")));
    GetVol("TPLT")->AddNode(GetVol("TOHO"),1,new TGeoTranslation(20.1,18.,0.));
    GetVol("TPLT")->AddNode(GetVol("TOHO"),2,new TGeoTranslation(-20.1,18.,0.));
    GetVol("TPLT")->AddNode(GetVol("TOHO"),3,new TGeoTranslation(-20.1,-18.,0.));
    GetVol("TPLT")->AddNode(GetVol("TOHO"),4,new TGeoTranslation(20.1,-18.,0.));
  GetVol("CARD")->AddNode(GetVol("MGSC"),1,new TGeoTranslation(0.,0.,-12.22544));
    GetVol("MGSC")->AddNode(GetVol("MGSH"),1,gGeoIdentity);


  SetMotherProp(GetVol("CARD"),1,new TGeoTranslation(0.,0.,87.439));

};

void  PamVMCDetCard::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "PLASTIC";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
  s = "IRON";  //default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
}
