#ifndef PAMVMC_AC_DIG_H
#define PAMVMC_AC_DIG_H

#include "PamVMCDigitizer.h"
#include <TF1.h>


using std::cout;
using std::endl;

class PamVMCAcDig  : public PamVMCDigitizer {


  Float_t fSumEcat[5], fSumEcas[5], fSumEcard[5];

  Bool_t fDEBUG;

  TF1*  fattenAC;

  void FillErel();
  
  void AddErel(TClonesArray* HitColl, Int_t detcode);

 public:

  PamVMCAcDig():PamVMCDigitizer("AC"){
    fattenAC = new TF1("fAttAC",".825+.64*atan(9.8/x)",0.,45.);
 }

  
  virtual ~PamVMCAcDig(){ delete fattenAC;}

  
  void Digitize(){; }; //not used

  void DigitizeAC(Int_t EventNo);


  ClassDef(PamVMCAcDig,1)
};


#endif //PAMVMC_AC_DIG_H
