#ifndef PAMVMC_DET_CARD_H
#define PAMVMC_DET_CARD_H

#include "PamVMCDetector.h"

#include "PamVMCCardSD.h"

class PamVMCCardSD;

class PamVMCDetCard  : public PamVMCDetector {

 public:


   PamVMCDetCard():PamVMCDetector("Card") 
  {;    };
 
  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "C1D1";
    PamVMCCardSD *c1d1 = new PamVMCCardSD(t);
    fdetSD.Add(new TObjString(t), c1d1);
    PamVMCSDMgr::Instance()->SetSD(t,c1d1);
    GetVol(t)->SetField(c1d1);

    t = "C2D1";
    PamVMCCardSD *c2d1 = new PamVMCCardSD(t);
    fdetSD.Add(new TObjString(t), c2d1);
    PamVMCSDMgr::Instance()->SetSD(t,c2d1);
    GetVol(t)->SetField(c2d1);
  }

  ClassDef(PamVMCDetCard,1)
};


#endif //PAMVMC_DET_CARD_H
