#include "PamVMCDetCat.h"

ClassImp(PamVMCDetCat)
void  PamVMCDetCat::DefineGeometry(){

 TGeoMaterial *m=0;
 TGeoMixture *x=0;
 TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID( 9);
  }


  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  
  if(!x){  
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID( 17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID( 19);
  }

  s = "PLAST";
  x = (TGeoMixture*)GetMat(s);
   if(!x){
     x = new TGeoMixture(s,2,   1.03200    );
     x->SetUniqueID( 28);
     x->DefineElement(0,12.01,6,0.9929774);
     x->DefineElement(1,1.01,1,0.7022570E-02);
   }

   s = "TIALVA";
   x = (TGeoMixture*)GetMat(s);
    if(!x){
      x = new TGeoMixture(s,3,   4.49234    );
      x->SetUniqueID( 32);
      x->DefineElement(0,47.867,22,0.9);
      x->DefineElement(1,26.9815,13,0.6000000E-01);
      x->DefineElement(2,50.9415,23,0.4000000E-01);
    }

    TGeoMedium *n =0;

  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);

  s = "SCINTILLATOR";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,10,17,1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "PLASTIC";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,18,28,-1,1,40,1,100,0.5000000E-01,0.1000000E-01,0.5000000E-03);

  s = "TITANIUM Mixture";
  n = (GetMed(s))?GetMed(s):new TGeoMedium(s,24,32,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.3200000E-01,0.5000000E-03);

 
  TGeoVolume *v = 0;

 TPLAfirst = kFALSE;
 s = "TPLA";
 v = GetVol(s);
 if(!v) {
   v = gGeoManager->MakeBox("TPLA",GetMed("N2 GAS"),28.,27.165,1.6);
   TPLAfirst = kTRUE;
 }

 s = "TPTU";
 v = (GetVol(s))?GetVol(s):gGeoManager->MakeBox(s,GetMed("TITANIUM Mixture"),2.55,1.95,0.6);
 s = "TPTM";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("TITANIUM Mixture"),3.45,3.3,0.75);
 s = "TPTL";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("TITANIUM Mixture"),21.9,21.1,0.25);
 s = "TPCV";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),8.5,7.,0.25);
 s = "CATA";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),28.,0.6,27.165);
 s = "ATBB";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),28.,0.6,27.165);
 s = "PLA2";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("PLASTIC"),27.65,0.4,26.815);
 s = "TOP1";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SCINTILLATOR"),26.85,0.4,26.015);
 s = "PTBM";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("PLASTIC"),10.11,0.4,8.44);
 s = "ATBM";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),9.41,0.4,7.74);
 s = "LTBM";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),9.11,0.6,7.44);
 s = "PTBC";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("PLASTIC"),4.975,0.4,5.5575);
 s = "ATBC";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),4.975,0.4,5.5575);
 s = "LTBC";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),4.975,0.6,5.5575);
 s = "PTRT";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("PLASTIC"),0.,16.9,0.4,2.405);
 s = "ATRT";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("ALUMINIUM"),0.,17.7,0.4,2.405);
 s = "LTRT";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("N2 GAS"),0.,18.05,0.6,2.405);
 s = "PTRB";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("PLASTIC"),16.9,0.,0.4,2.405);
 s = "ATRB";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("ALUMINIUM"),17.7,0.,0.4,2.405);
 s = "LTRB";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("N2 GAS"),18.05,0.,0.6,2.405);
 s = "PTRL";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("PLASTIC"),0.,14.9,0.4,2.375);
 s = "ATRL";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("ALUMINIUM"),0.,15.7,0.4,2.375);
 s = "LTRL";
 v = (GetVol(s))?GetVol(s): gGeoManager->MakeTrd1(s,GetMed("N2 GAS"),0.,16.05,0.6,2.375);

   GetVol("TPTL")->AddNode(GetVol("TPCV"),1,gGeoIdentity);
   GetVol("CATA")->AddNode(GetVol("ATBB"),1,gGeoIdentity); //only
     GetVol("ATBB")->AddNodeOverlap(GetVol("PLA2"),1,gGeoIdentity); //only
       GetVol("PLA2")->AddNodeOverlap(GetVol("TOP1"),1,gGeoIdentity); //only
         GetVol("TOP1")->AddNode(GetVol("PTBM") ,1,gGeoIdentity);//only
	 GetVol("TOP1")->AddNode(GetVol("PTBC"),1,new TGeoTranslation(-21.875,0.,20.4575));
	 GetVol("TOP1")->AddNode(GetVol("PTBC"),2,new TGeoTranslation(21.875,0.,20.4575));
	 GetVol("TOP1")->AddNode(GetVol("PTBC"),3,new TGeoTranslation(-21.875,0.,-20.4575));
	 GetVol("TOP1")->AddNode(GetVol("PTBC"),4,new TGeoTranslation(21.875,0.,-20.4575));
	 GetVol("TOP1")->AddNode(GetVol("PTRT"),1,new TGeoTranslation(0.,0.,23.61));
	 GetVol("TOP1")->AddNode(GetVol("PTRB"),1,new TGeoTranslation(0.,0.,-23.61));
	 GetVol("TOP1")->AddNode(GetVol("PTRL"),1,new TGeoCombiTrans(-24.475,0.,0.,GetRot("rot7")));
	 GetVol("TOP1")->AddNode(GetVol("PTRL"),2,new TGeoCombiTrans(24.475,0.,0.,GetRot("rot8")));
	 GetVol("PLA2")->AddNode(GetVol("ATBM"),1,gGeoIdentity);
	 GetVol("PLA2")->AddNode(GetVol("ATBC"),1,new TGeoTranslation(-22.675,0.,21.2575));
	 GetVol("PLA2")->AddNode(GetVol("ATBC"),2,new TGeoTranslation(22.675,0.,21.2575));
	 GetVol("PLA2")->AddNode(GetVol("ATBC"),3,new TGeoTranslation(-22.675,0.,-21.2575));
	 GetVol("PLA2")->AddNode(GetVol("ATBC"),4,new TGeoTranslation(22.675,0.,-21.2575));
	 GetVol("PLA2")->AddNode(GetVol("ATRT"),1,new TGeoTranslation(0.,0.,24.41));
	 GetVol("PLA2")->AddNode(GetVol("ATRB"),1,new TGeoTranslation(0.,0.,-24.41));
	 GetVol("PLA2")->AddNode(GetVol("ATRL"),1,new TGeoCombiTrans(-25.275,0.,0.,GetRot("rot7")));
	 GetVol("PLA2")->AddNode(GetVol("ATRL"),2,new TGeoCombiTrans(25.275,0.,0.,GetRot("rot8")));
     GetVol("ATBB")->AddNode(GetVol("LTBM"),1,gGeoIdentity);
     GetVol("ATBB")->AddNode(GetVol("LTBC"),1,new TGeoTranslation(-23.025,0.,21.6075));
     GetVol("ATBB")->AddNode(GetVol("LTBC"),2,new TGeoTranslation(23.025,0.,21.6075));
     GetVol("ATBB")->AddNode(GetVol("LTBC"),3,new TGeoTranslation(-23.025,0.,-21.6075));
     GetVol("ATBB")->AddNode(GetVol("LTBC"),4,new TGeoTranslation(23.025,0.,-21.6075));
     GetVol("ATBB")->AddNode(GetVol("LTRT"),1,new TGeoTranslation(0.,0.,24.76));
     GetVol("ATBB")->AddNode(GetVol("LTRB"),1,new TGeoTranslation(0.,0.,-24.76));
     GetVol("ATBB")->AddNode(GetVol("LTRL"),1,new TGeoCombiTrans(-25.625,0.,0.,GetRot("rot7")));
     GetVol("ATBB")->AddNode(GetVol("LTRL"),2,new TGeoCombiTrans(25.625,0.,0.,GetRot("rot8")));
    GetVol("TPLA")->AddNodeOverlap(GetVol("TPTU"),1,new TGeoTranslation(-20.65,-20.15,1.));
    GetVol("TPLA")->AddNodeOverlap(GetVol("TPTU"),2,new TGeoTranslation(-20.65,20.15,1.));
    GetVol("TPLA")->AddNodeOverlap(GetVol("TPTU"),3,new TGeoTranslation(20.65,-20.15,1.));
    GetVol("TPLA")->AddNodeOverlap(GetVol("TPTU"),4,new TGeoTranslation(20.65,20.15,1.));


  if(TPLAfirst) SetMotherProp(GetVol("TPLA"),1,new TGeoTranslation(0.,0.,73.489));
  
  GetVol("TPLA")->AddNode(GetVol("TPTL"),1,new TGeoTranslation(0.,0.,-1.35));
  GetVol("TPLA")->AddNode(GetVol("TPTM"),1,new TGeoTranslation(-19.75,-18.8,-0.35));
  GetVol("TPLA")->AddNode(GetVol("TPTM"),2,new TGeoTranslation(-19.75,18.8,-0.35));
  GetVol("TPLA")->AddNode(GetVol("TPTM"),3,new TGeoTranslation(19.75,-18.8,-0.35));
  GetVol("TPLA")->AddNode(GetVol("TPTM"),4,new TGeoTranslation(19.75,18.8,-0.35));
  GetVol("TPLA")->AddNode(GetVol("CATA"),1,new TGeoCombiTrans(0.,0.,1.,GetRot("rot2")));
};

void  PamVMCDetCat::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s ="SCINTILLATOR";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s = "PLASTIC";// default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
  s = "TITANIUM Mixture"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s)) 
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   

}
