#ifndef PAMVMCTRK_F77_GPSSPE
#define PAMVMCTRK_F77_GPSSPE

#include <TObject.h>
#include <TClonesArray.h>
#include "PamRootManager.h"
#include <iostream>

using std::cout;
using std::endl; 
// structures for C++ <=> COMMON data exchange

#define maxstr 5000

struct cGPSSPE  {
  Int_t nstrpx;
  Int_t nstrpy;
  Int_t istripx[maxstr];
  Int_t istripy[maxstr];
  Float_t qstripx[maxstr];
  Float_t qstripy[maxstr];
  Float_t xstripx[maxstr];
  Float_t ystripy[maxstr];
  Int_t npstripx[maxstr];
  Int_t npstripy[maxstr];
  Int_t ntstripx[maxstr];
  Int_t ntstripy[maxstr];
} ;

extern "C" {
  extern struct cGPSSPE gpsspe_;
}

class GPSSPEData: public TObject {
  
 public:
  
  Int_t fistrip;
  Float_t fqstrip;
  Float_t fstripc;
  Int_t fnpstrip;
  Int_t fntstrip;

  GPSSPEData(){fistrip=fnpstrip=fntstrip=0; fqstrip=fstripc=0.;}

  virtual ~GPSSPEData(){; };
  
  void Clean(){fistrip=fnpstrip=fntstrip=0; fqstrip=fstripc=0.;}

  void Clear(Option_t * = "") { this->~GPSSPEData(); }

  void Print(Option_t * ="" ) const {
    cout<<"   ISTRIP:  " <<fistrip<<" (Strip ID in all plane)"<<endl
	<<"   QSTRIP:  " <<fqstrip<<" (ADC value in strip)"<<endl
	<<"   CSTRIP:  " <<fstripc<<" (Strip coordinate)"<<endl
	<<"   NPSTRIP: " <<fnpstrip<<" (Plane No)"<<endl
	<<"   NTSTRIP: " <<fntstrip<<" (Sensor No)"<<endl;
  }

  ClassDef(GPSSPEData,1);
};

class pGPSSPEHits{

 private:

  Int_t fnstrpx;
  Int_t fnstrpy;
  TClonesArray * fGPSSPEDataXColl;
  TClonesArray * fGPSSPEDataYColl;

 public:

  pGPSSPEHits():fnstrpx(0), fnstrpy(0){
    fGPSSPEDataXColl = new TClonesArray("GPSSPEData",1000);
    fGPSSPEDataYColl = new TClonesArray("GPSSPEData",1000);
  }

  virtual ~pGPSSPEHits(){ delete  fGPSSPEDataYColl; delete fGPSSPEDataXColl; }

  void Clean() {
    fnstrpx=fnstrpy=0;
    (*fGPSSPEDataXColl).Clear("C");
    (*fGPSSPEDataYColl).Clear("C");
  }

  void Clear( Option_t * = "") { Clean(); }

  void Compress(){
    fGPSSPEDataXColl->Compress();
    fGPSSPEDataYColl->Compress();
  }
  
  GPSSPEData * CreateXHit(Int_t flag){
    if(!fGPSSPEDataXColl->At(flag)){
      return (GPSSPEData *)fGPSSPEDataXColl->New(flag);
    }
    return (GPSSPEData *)fGPSSPEDataXColl->At(flag);
  }

  GPSSPEData * CreateYHit(Int_t flag){
    if(!fGPSSPEDataYColl->At(flag)){      
      return (GPSSPEData *)fGPSSPEDataYColl->New(flag);
    }
    return (GPSSPEData *)fGPSSPEDataYColl->At(flag);
  }

  Int_t GetNXHit(){ return fnstrpx; }
  
  Int_t GetNYHit(){ return fnstrpy; }

  GPSSPEData * GetXHit(Int_t flag){
    if(fGPSSPEDataXColl->At(flag)){
      GPSSPEData * hit = (GPSSPEData *)fGPSSPEDataXColl->At(flag);
      return hit;
  }
    cout<<"Tracker GPSSPE_X Hit at "<<flag<<" is empry"<<endl;
    return 0;
  }
  
  GPSSPEData * GetYHit(Int_t flag){
  if(fGPSSPEDataYColl->At(flag)){
    GPSSPEData * hit = (GPSSPEData *)fGPSSPEDataYColl->At(flag);
    return hit;
  }
  cout<<"Tracker GPSSPE_Y Hit at "<<flag<<" is empry"<<endl;
  return 0;
  }
  
  void SetData(cGPSSPE * c){

    fnstrpx=c->nstrpx;
    fnstrpy=c->nstrpy;
    for (Int_t i=0; i<fnstrpx; i++){
      GPSSPEData *hx = CreateXHit(i);
      hx->fqstrip=c->qstripx[i];
      hx->fstripc=c->xstripx[i];
      hx->fnpstrip=c->npstripx[i];
      hx->fntstrip=c->ntstripx[i];
      hx->fistrip=c->istripx[i];     
    }
    for (Int_t i=0; i<fnstrpy; i++){
      GPSSPEData *hy = CreateYHit(i);  
      hy->fqstrip=c->qstripy[i];
      hy->fstripc=c->ystripy[i];
      hy->fnpstrip=c->npstripy[i];
      hy->fntstrip=c->ntstripy[i];
      hy->fistrip=c->istripy[i];  
    }
    
  }
  
  void Print(Option_t * ="" ) const
    { cout << "pGPSSPEHitData: "<<endl
	   <<"NSTRPX Number of hits (X View):" << fnstrpx 
	   <<"   NSTRPY Number of hits (Y View):" << fnstrpy << endl;
    for (Int_t i=0; i<fnstrpx; i++){
      cout<<"HIT #" << i << " (X View):" << endl;
      GPSSPEData * hx = (GPSSPEData *)fGPSSPEDataXColl->At(i);
      if(hx) hx->Print();  
    }
    for (Int_t i=0; i<fnstrpy; i++){
      cout<<"HIT #" << i << " (Y View):" << endl;
      GPSSPEData * hy = (GPSSPEData *)fGPSSPEDataYColl->At(i);
      if (hy) hy->Print();
    }
    }
  
  ClassDef(pGPSSPEHits,1)
    
    };
    
#endif
    
