#ifndef PAMVMC_DETECTOR_H
#define PAMVMC_DETECTOR_H
#include <iostream>

#include <TMap.h>
#include <TObject.h>
#include <TString.h>

#include "PamVMCSDMgr.h"

#include "pCutControl.h"
#include "PamVMCCutContMgr.h"

#include "PamVMCDetectorSD.h"
#include "PamVMCDetGeom.h"
#include "PamVMCGeoRotMgr.h"

class PamVMCDetGeom;

class PamVMCDetector  : public TObject {

 protected:

  TString fdname;
  TMap fdetSD; //map of pointers to SD collection
  TMap fsubdet; //map of pointers to subdetectors;
  PamVMCDetGeom *fdetgeom; //geometry
  //  TObjArray fdetmother; //array of pointers to mother volumes and matrix
  

 public:


   PamVMCDetector(const char *dname="NoDetector" ): 
     fdname(dname), fdetgeom(0)
  {
    fdetgeom = new PamVMCDetGeom(dname);
  };
  
  
  virtual ~PamVMCDetector() { 
    fdetSD.DeleteAll();
    fsubdet.DeleteAll(); 
    delete fdetgeom;
  }
  
  virtual void DefineGeometry() = 0;

  virtual void DefineCuts() = 0;

  void SetCuts() { PamVMCCutContMgr::Instance()->SetCuts(); };

  virtual void ConstructGeometry(){
    
    TMapIter *n= (TMapIter *)fsubdet.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
      ((PamVMCDetector*)fsubdet.GetValue(o))->ConstructGeometry();
    }
    delete n;
    
    DefineGeometry();
      

    AddMotherProp();
    if(GetMotherVol()){ 
      fdetgeom->SetMotherVol(GetMotherVol());
      fdetgeom->RegisterNodes();
    }
     

  }

  //will be mobydyed o register all cuts, defined in map of CCManager
  virtual void ConstructCuts(){

    TMapIter *n= (TMapIter *)fsubdet.MakeIterator();
    TObject *o; while( (o=(TObject *) n->Next())) {
      ((PamVMCDetector*)fsubdet.GetValue(o))->ConstructCuts();
    }

    DefineCuts();
    delete n;
  }

  virtual void InitGeometry(){

    TMapIter *n= (TMapIter *)fsubdet.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
      ((PamVMCDetector*)fsubdet.GetValue(o))->InitGeometry();
    }

    SetCuts();
    delete n;
  }

  virtual TGeoVolume* GetMotherVol(){ return 0; };

  virtual void InitMC(){

   TMapIter *n= (TMapIter *)fsubdet.MakeIterator(); 
   TObject *o; while( (o=(TObject *) n->Next())) { 
     ((PamVMCDetector*)fsubdet.GetValue(o))->InitMC();
   }
   delete n;
  };


  TGeoRotation* GetRot(const char*name){ return PamVMCGeoRotMgr::Instance()->GetRot(name); }
  void AddRot(const char*name, TGeoRotation*rot){ PamVMCGeoRotMgr::Instance()->AddRot(name, rot); }

  void AddMotherProp(TObjArray *mp) { fdetgeom->AddMotherProp(mp); }

  void AddMotherProp() {     
    TMapIter *n= (TMapIter *)fsubdet.MakeIterator(); 
    TObject *o=0; 
    while( (o=(TObject *) n->Next())) { 
      AddMotherProp( ((PamVMCDetector*)(fsubdet.GetValue(o)))->GetMotherProp() );
    }
    delete n;
  }

  void SetMotherProp(TGeoVolume *mv, Int_t cn, TGeoMatrix* mx){
    fdetgeom->SetMotherProp(mv,cn,mx);
  }

  void SetCC(const char *medname, pCutControl * pCC) { 
    PamVMCCutContMgr::Instance()->SetCutCont(medname, pCC);
  }   
  pCutControl *  GetCC(const char *medname) {
   return PamVMCCutContMgr::Instance()->GetCutCont(medname);
  }

  TObjArray* GetMotherProp(){ return fdetgeom->GetMotherProp(); }

  void SetMotherVol(TGeoVolume *mv) { fdetgeom->SetMotherVol(mv); }

  void RegisterNodes() { fdetgeom->RegisterNodes(); }
  
  Int_t GetMedID(const char* name){ return fdetgeom->GetMedID(name); }

  TGeoMaterial* GetMat(const char* name){ return fdetgeom->GetMat(name); }

  TGeoMedium* GetMed(const char* name){ return fdetgeom->GetMed(name); }

  TGeoVolume* GetVol(const char* name){ return fdetgeom->GetVol(name); }

  virtual void PrintMediumCuts(const Option_t* =""){
    PamVMCCutContMgr::Instance()->Print();
  }  

  virtual void Print(const Option_t* ="") const {    
    std::cout<<"DETECTOR "<<fdname<<" HIT COLLECTIONS:"<<std::endl;
    PrintHitColl();
    PrintGeoColl();
  }

  virtual void PrintColl(const TMap *tm, const char* label=" HIT COLLECTIONS: ",const Option_t* ="") const {
    
    std::cout<<"DETECTOR "<<fdname<<label << std::endl;
    TMapIter *n= (TMapIter *)tm->MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
      ((PamVMCDetectorSD *)tm->GetValue(o))->Print();
    }
    delete n;
  }
  
  virtual void PrintHitColl(const Option_t* = "") const { PrintColl(&fdetSD," HIT COLLECTION: "); }
  virtual void PrintGeoColl(const Option_t* = "") const { PrintColl(&fsubdet," SUBDETECTOR COLLECTION: "); }
  
  ClassDef(PamVMCDetector,1)
};


#endif //PAMVMC_DETECTOR_H
