      SUBROUTINE GPRSPE(ANGLEX,ANGLEY,BMAGNET,XMULT,YMULT,DXPOS,DYPOS)
**************************************************************************
*                                                                        *
*    Perform SPE resolution simulation for one hit                       *
*                                                                        * 
*                                                                        * 
*    ANGLEX  ,  angle between the X projected track and the axis         *
*                normal to silicon surface                               *
*                                                                        *
*    ANGLEY  ,  angle between the Y projected track and the axis         *
*                normal to silicon surface                               *		                                                         *
*                                                                        *
*    BMAGNET   ,   value of magnetic field to be considered              *
*                                                                        *
*                                                                        *
*    SMULT     ,   on exit is  the strip multiplicity                    *
*                                                                        *
*                                                                        *
*    DXPOS     ,   on exit is the shift in X determination               *
*                                                                        *
*                                                                        *
*    DYPOS     ,   on exit is the shift in Y determination               *
*                                                                        *
*                                                                        *
* Called by: gpdspe                                                      *
* Author: Sergio Bottai, 25/05/05  4.40.38                               *
*                                                                        *
**************************************************************************
#include "gprspe.inc"
#include "gpdrspe.inc"
      REAL BMAGNET(3),ANGLEX,ANGLEY,XMULT,YMULT,DXPOS,DYPOS
      PARAMETER (RADDEG=57.2957795130823209)
      REAL RVAL1(1),XRAN1
      INTEGER IANGLEX,IANGLEY

      YMULT=1.
      XMULT=1.
      DXPOS=0.
      DYPOS=0.


C
C FIND THE X ANGULAR BIN
C      
      IANGLEX=NBINANG
      IF(VANG(12).LE.ANGLEX) GO TO 123
      DO II=1,NBINANG
         IF((VANG(II).LE.ANGLEX).AND.(ANGLEX.LE.VANG(II+1))) THEN
            IANGLEX=II
	    GO TO 123 
	 ENDIF    
      ENDDO
123   CONTINUE
c      PRINT*,'IANGX ',IANGLEX
C
C SAMPLE THE X MULTIPLICITY
C      
      CALL GRNDM(RVAL1,1)
     
      XRAN1=RVAL1(1)
      IF(XRAN1.LE.XMULT1_2(IANGLEX)) THEN
         XMULT=2.
      ELSE IF((XMULT1_2(IANGLEX).LT.XRAN1).
     +        AND.(XRAN1.LE.XMULT3(IANGLEX)) ) THEN
         XMULT=3.
      ELSE
         XMULT=4.
      ENDIF



      IF( (ANGLEX.LE.ANGLECUT.AND.XMULT.LE.2).OR.
     + (ANGLEX.GT.ANGLECUT.AND.XMULT.LE.3) ) THEN
C
C LMS CONDITION IS MET, SAMPLE THE X RESIDUALS
C        
         CALL GPRNHRAN(WX(1,IANGLEX),NDHIRES,-150.,0.3,DXPOS)  
        
C
C TRANSFORM IN CM
C
         DXPOS=DXPOS*1.E-4
	      
      ELSE 
C
C HMS CONDITION IS MET, SAMPLE THE X RESIDUALS
C      
         DXPOS = GPGAUS(0.)*XRMSHMS(IANGLEX)
	 DXPOS=DXPOS*1.E-4
      ENDIF


C
C FIND THE Y ANGULAR BIN
C      
      IANGLEY=NBINANG
      IF(VANG(12).LE.ANGLEY) GO TO 124
      DO II=1,NBINANG
         IF((VANG(II).LE.ANGLEY).AND.(ANGLEY.LE.VANG(II+1))) THEN
            IANGLEY=II
	    GO TO 124 
	 ENDIF    
      ENDDO
124   CONTINUE

C
C SAMPLE THE Y RESIDUALS
C
      CALL GPRNHRAN(WY(1,IANGLEY),NDHIRES,-150.,0.3,DYPOS)
C
C TRANSFORM IN CM
C

      DYPOS=DYPOS*1.E-4
   

      RETURN
      END
