#ifndef PAMVMC_DET_TRK_H
#define PAMVMC_DET_TRK_H

#include "PamVMCDetector.h"

#include "PamVMCTrkSD.h"

class PamVMCTrkSD;
class PamVMCTPANSD;
class PamVMCTRCNSD;
class PamVMCTRSLSD;

class PamVMCDetTrk  : public PamVMCDetector {

 public:


   PamVMCDetTrk():PamVMCDetector("Tracker") 
  {;  };
 
  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "TSPA";
    PamVMCTrkSD *trk = new PamVMCTrkSD();
    fdetSD.Add(new TObjString(t), trk);
    PamVMCSDMgr::Instance()->SetSD("TSPA",trk);

    t = "TPAN";
    PamVMCTPANSD *tpan = new PamVMCTPANSD();
    fdetSD.Add(new TObjString(t), tpan);
    PamVMCSDMgr::Instance()->SetSD("TPAN",tpan);

    t = "TRCN";
    PamVMCTRCNSD *trcn = new PamVMCTRCNSD();
    fdetSD.Add(new TObjString(t), trcn);
    PamVMCSDMgr::Instance()->SetSD("TRCN",trcn);

    t = "TRSL";
    PamVMCTRSLSD *trsl = new PamVMCTRSLSD();
    fdetSD.Add(new TObjString(t), trsl);
    PamVMCSDMgr::Instance()->SetSD("TRSL",trsl);


  }

  ClassDef(PamVMCDetTrk,1)
};


#endif //PAMVMC_DET_TRK_H
