#ifndef PAMVMC_CROSS_TRK_H
#define PAMVMC_CROSS_TRK_H

#include "PamVMCVolCross.h"

class PamVMCCrossTRK  : public PamVMCVolCross {

 private:

  Bool_t fTRK1;
  Bool_t fTRK2;
  Bool_t fTRK3;
  Bool_t fTRK4;
  Bool_t fTRK5;
  Bool_t fTRK6;

 public:

   PamVMCCrossTRK():PamVMCVolCross("TSPA") 
  { fTRK1=kFALSE; 
    fTRK2=kFALSE;
    fTRK3=kFALSE;
    fTRK4=kFALSE;
    fTRK5=kFALSE;
    fTRK6=kFALSE;
  };

 
   Int_t GetPlaneNo(){ 
     Int_t pl = Int_t((fdetID->GetID())/6.+1); 
     if(pl==7) pl=6;
     return pl;
   }
   
  virtual void FillCrossMap(){ 
    Int_t pl = GetPlaneNo();
    //fdetID->Print();
    //cout<<"Stepsize"<<gMC->TrackStep()*10000<<"um in plane"<<pl<<" particle is:"<<gMC->TrackPid()<<endl;
    switch(pl){
    case 1:
      fTRK1=kTRUE;
      break;
    case 2:
      fTRK2=kTRUE;
      break;
    case 3:
      fTRK3=kTRUE;
      break;
    case 4:
      fTRK4=kTRUE;
      break;
    case 5:
      fTRK5=kTRUE;
      break;
    case 6:
      fTRK6=kTRUE;
      break;
     default:
      break;
    }
}

  Bool_t IsVolCross(){ return fTRK1*fTRK2*fTRK3*fTRK4*fTRK5*fTRK6; }

  virtual void Reset(){
    fTRK1=kFALSE; 
    fTRK2=kFALSE;
    fTRK3=kFALSE;
    fTRK4=kFALSE;
    fTRK5=kFALSE;
    fTRK6=kFALSE;
  }
  
  ClassDef(PamVMCCrossTRK,1)
};


#endif //PAMVMC_CROSS_TRK_H
