#ifndef PAMVMCTRKID_H
#define PAMVMCTRKID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define TRKOF 2

using std::cout;
using std::endl;

struct pTrkID: public pGeoID {
  Int_t plNo;
  Int_t padNo;
 

  pTrkID(): plNo(-1), padNo(-1) {};
  pTrkID(Int_t offset): pGeoID(offset), plNo(-1), padNo(-1) {};
  pTrkID & operator = (const pTrkID &pid) {
    plNo=pid.plNo;
    padNo=pid.padNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
        Int_t TRPB;
	gMC->CurrentVolOffID(3,TRPB);
        TRPB==2 ? plNo=6 : gMC->CurrentVolOffID(4,plNo);       
      	gMC->CurrentVolOffID(1,padNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return (plNo-1)*6+padNo; }

  void Print(const Option_t* ="") const { 
    cout << " pTrkID : plNo " << plNo <<endl;
    cout << " pTrkID : padNo " << padNo <<endl;
  }

};
#endif //PAMVMCTrkID_H




#ifndef PAMVMCTPANID_H
#define PAMVMCTPANID_H
struct pTrkTPAN_ID: public pGeoID {
  Int_t plNo;
 
 pTrkTPAN_ID(): plNo(-1) {};
 pTrkTPAN_ID(Int_t offset): pGeoID(offset), plNo(-1){};
 pTrkTPAN_ID & operator = (const pTrkTPAN_ID &pid) {
   plNo=pid.plNo;
   return *this;
  }

 Bool_t FillVolID(){
   Bool_t t=kFALSE;
   if(gMC) {
     Int_t TRPB;
     gMC->CurrentVolOffID(2,TRPB);
     TRPB==2 ? plNo=6 : gMC->CurrentVolOffID(3,plNo);       
     t= kTRUE;
    }
   return t;
 }

 Int_t GetID() const { return (plNo-1); }
 
 void Print(const Option_t* ="") const { 
   cout << " pTrkTPAN_ID : plNo " << plNo <<endl;
 }
 
};
#endif //PAMVMCTPANID_H

#ifndef PAMVMCTRCNID_H
#define PAMVMCTRCNID_H
struct pTrkTRCN_ID: public pGeoID {
  Int_t plNo;
  Int_t padNo;

  pTrkTRCN_ID(): plNo(-1), padNo(-1) {};
  pTrkTRCN_ID(Int_t offset): pGeoID(offset), plNo(-1), padNo(-1) {};
  pTrkTRCN_ID & operator = (const pTrkTRCN_ID &pid) {
    plNo=pid.plNo;
    padNo=pid.padNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
        Int_t TRPB;
	gMC->CurrentVolOffID(3,TRPB);
        TRPB==2 ? plNo=6 : gMC->CurrentVolOffID(4,plNo);       
      	gMC->CurrentVolOffID(1,padNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return (plNo-1)*4+padNo; } // 1- 2- 3- 4 first plane
                                                   //21-22-23-24 last plane

  void Print(const Option_t* ="") const { 
    cout << " pTrkTRCN_ID : plNo " << plNo <<endl;
    cout << " pTrkTRCN_ID : padNo " << padNo <<endl;
  }
};
#endif //PAMVMCTrkTRCN_ID_H

#ifndef PAMVMCTRSLID_H
#define PAMVMCTRSLID_H
struct pTrkTRSL_ID: public pGeoID {
  Int_t plNo;
  Int_t padNo;
 
  pTrkTRSL_ID(): plNo(-1), padNo(-1) {};
  pTrkTRSL_ID(Int_t offset): pGeoID(offset), plNo(-1), padNo(-1) {};
  pTrkTRSL_ID & operator = (const pTrkTRSL_ID &pid) {
    plNo=pid.plNo;
    padNo=pid.padNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
        Int_t TRPB;
	gMC->CurrentVolOffID(2,TRPB);
        TRPB==2 ? plNo=6 : gMC->CurrentVolOffID(3,plNo);       
      	gMC->CurrentVolID(padNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return (plNo-1)*6+padNo; }

  void Print(const Option_t* ="") const { 
    cout << " pTrkTRSL_ID : plNo " << plNo <<endl;
    cout << " pTrkTRSL_ID : padNo " << padNo <<endl;
  }
};
#endif //PAMVMCTrkID_H
