#ifndef PAMVMC_DET_TOF_S1_H
#define PAMVMC_DET_TOF_S1_H

#include "PamVMCDetector.h"

#include "PamVMCTofSD.h"

class PamVMCTofSD;

class PamVMCDetTofS1  : public PamVMCDetector {

 public:


   PamVMCDetTofS1():PamVMCDetector("S1") 
  {  };

   void DefineGeometry();

   void DefineCuts();

  virtual void InitMC(){

    TString t = "S11Y";
    PamVMCTofSD *s11y = new PamVMCTofSD("S11Y");
    fdetSD.Add(new TObjString(t), s11y);
    PamVMCSDMgr::Instance()->SetSD("S11Y",s11y);

    t = "S12X";
    PamVMCTofSD *s12x = new PamVMCTofSD("S12X");
    fdetSD.Add(new TObjString(t), s12x);
    PamVMCSDMgr::Instance()->SetSD("S12X",s12x);
  }

  ClassDef(PamVMCDetTofS1,1)
};


#endif //PAMVMC_DET_TOF_S1_H
