#ifndef PAMVMC_DET_TOF_S2_H
#define PAMVMC_DET_TOF_S2_H

#include "PamVMCDetector.h"

#include "PamVMCTofSD.h"

class PamVMCTofSD;

class PamVMCDetTofS2  : public PamVMCDetector {

 private:

 Bool_t TPLAfirst;

 public:


   PamVMCDetTofS2():PamVMCDetector("S2") 
  {;  };
 
  void DefineGeometry();

  void DefineCuts();

  virtual void InitMC(){

    TString t = "S21X";
    PamVMCTofSD *s21x = new PamVMCTofSD("S21X");
    fdetSD.Add(new TObjString(t), s21x);
    PamVMCSDMgr::Instance()->SetSD("S21X",s21x);

    t = "S22Y";
    PamVMCTofSD *s22y = new PamVMCTofSD("S22Y");
    fdetSD.Add(new TObjString(t), s22y);
    PamVMCSDMgr::Instance()->SetSD("S22Y",s22y);
  }

  ClassDef(PamVMCDetTofS2,1)
};


#endif //PAMVMC_DET_TOF_S2_H
