#ifndef PAMVMC_CROSS_MGPL_H
#define PAMVMC_CROSS_MGPL_H

#include "PamVMCVolCross.h"

class PamVMCCrossMGPL  : public PamVMCVolCross {

 private:

  Bool_t fMGPL;

 public:

   PamVMCCrossMGPL():PamVMCVolCross("MGPL") 
  { fMGPL=kTRUE; };
   
   virtual void CrossVol(){ FillCrossMap(); };
   
   virtual void FillCrossMap(){ fMGPL=kFALSE; }
   
   Bool_t IsVolCross(){ return fMGPL; }
   
   virtual void Reset(){ fMGPL=kTRUE; }
   
   ClassDef(PamVMCCrossMGPL,1)
};


#endif //PAMVMC_CROSS_MGPL_H

#ifndef PAMVMC_CROSS_MGPA_H
#define PAMVMC_CROSS_MGPA_H



class PamVMCCrossMGPA  : public PamVMCVolCross {

 private:

  Bool_t fMGPA;

 public:

   PamVMCCrossMGPA():PamVMCVolCross("MGPA") 
  { fMGPA=kTRUE; };

  virtual void CrossVol(){ FillCrossMap(); };
   
  virtual void FillCrossMap(){ fMGPA=kFALSE;}

  Bool_t IsVolCross(){ return fMGPA; }

  virtual void Reset(){ fMGPA=kTRUE; }

  ClassDef(PamVMCCrossMGPA,1)
};


#endif //PAMVMC_CROSS_MGPA_H
