// $Id: PamVMCStack.h,v 1.0 2007/06/03 
//
// Class PamVMCStack


#ifndef PAMVMC_STACK_H
#define PAMVMC_STACK_H

#include <TVirtualMCStack.h>

#include "PamVMCParticle.h"

#include <stack>

class PamVMCParticle;
class TClonesArray;

class PamVMCStack : public TVirtualMCStack
{
  public:
    PamVMCStack(Int_t size);
    PamVMCStack();
    virtual ~PamVMCStack();     

    // methods
    virtual void  PushTrack(Int_t toBeDone, Int_t parent, Int_t pdg,
  	              Double_t px, Double_t py, Double_t pz, Double_t e,
  		      Double_t vx, Double_t vy, Double_t vz, Double_t tof,
		      Double_t polx, Double_t poly, Double_t polz,
		      TMCProcess mech, Int_t& ntr, Double_t weight,
		      Int_t is) ;
    virtual PamVMCParticle* PopNextTrack(Int_t& track);
    virtual PamVMCParticle* PopPrimaryForTracking(Int_t i); 
    virtual void Print(Option_t* option = "") const;   
    void Reset();   
   
    // set methods
    virtual void  SetCurrentTrack(Int_t track);                           

    // get methods
    virtual Int_t  GetNtrack() const;
    virtual Int_t  GetNprimary() const;
    virtual PamVMCParticle* GetCurrentTrack() const;   
    virtual Int_t  GetCurrentTrackNumber() const;
    virtual Int_t  GetCurrentParentTrackNumber() const;
    PamVMCParticle*     GetParticle(Int_t id) const;
    
  private:
    // data members
    std::stack<PamVMCParticle*>  fStack;    //!
    TClonesArray*           fParticles;
    Int_t                   fCurrentTrack;
    Int_t                   fNPrimary;
    
    ClassDef(PamVMCStack,1) // PamVMCStack
};

#endif //PAMVMC_STACK_H   
   

