#! /bin/bash

CAT="/bin/cat"
SED="/bin/sed"
RM="/bin/rm"
QSUB="/sge-root/bin/lx24-x86/qsub"
SEQ="/usr/bin/seq"

PIN_DIR="${PWD}/pin"
POUT_DIR="${PWD}/pout"
PERR_DIR="${PWD}/perr"

SETPAMENV="/opt/vmc.sh"
WORKDIR="${PWD}"
INPUT_KINEMATICS="/home/nikonov/HE_SIM/points_logbins40/*"
RUN_G4_SIM="${PWD}/run_sim_g4.C"

script="${PWD}/run_single_job.sh"

configmacro="g4Config.C"
 
for i in ${INPUT_KINEMATICS}
  do
    prefix1="${i##/*/}"
    prefix="${prefix1%.*}"
    echo $prefix
    echo $i
    pin="${prefix}.in.txt"
    pin="${PIN_DIR}/${pin}"
    if [ -e $pin ]; then
	$RM -f $pin
    fi
    pout="${prefix}.out.txt"
    pout="${POUT_DIR}/${pout}"
    if [ -e $pout ]; then
	$RM -f $pout
    fi
    perr="${prefix}.err.txt"
    perr="${PERR_DIR}/${perr}"
    if [ -e $perr ]; then
	$RM -f $perr
    fi
    
    echo $SETPAMENV >> $pin
    echo $RUN_G4_SIM >> $pin
    echo $configmacro >> $pin
    echo $i >> $pin

    $QSUB -wd $WORKDIR -e $perr -i $pin -o $pout $script
done
exit 0
