#include "PamVMCDetCalo.h"

ClassImp(PamVMCDetCalo)

 void PamVMCDetCalo::DefineGeometry(){

 
  TGeoMaterial *m=0;
  TGeoMixture *x=0;
  TString s = "ALUMINIUM"; 
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,26.98,13,2.7);
    m->SetUniqueID(   9);
  }

  s = "SCINT";
  x = (TGeoMixture*)GetMat(s);  //!!!! CHECK IT NOT SCINTILLATOR !!!
  if(!x){
    x = new TGeoMixture(s,2,   1.03200    );
    x->SetUniqueID(  17);
    x->DefineElement(0,12.01,6,0.922427);
    x->DefineElement(1,1.01,1,0.7757296E-01);
  }

  s = "N2GAS";
  m = GetMat(s);
  if (!m){
    m = new TGeoMaterial(s,14.01,7,0.1250000E-02);
    m->SetUniqueID(  19);
  }

  s = "SILICON CA";
  m = GetMat(s);
  if(!m){
    m = new TGeoMaterial(s,28.09,14,2.33);
    m->SetUniqueID(  21);
  }

  s = "TUNGA";
  x = (TGeoMixture*)GetMat(s);
  if(!x){ 
    x = new TGeoMixture(s,3,   18.1000    );
    x->SetUniqueID(  25);
    x->DefineElement(0,183.5,74,0.9827841);
    x->DefineElement(1,58.6934,28,0.8272327E-02);
    x->DefineElement(2,63.456,29,0.8943575E-02);
  }

  s = "CERAMIC";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,4,   2.59400    );
    x->SetUniqueID(  26);
    x->DefineElement(0,26.98,13,0.21);
    x->DefineElement(1,28.09,14,0.217);
    x->DefineElement(2,16.,8,0.558);
    x->DefineElement(3,1.01,1,0.1500000E-01);
  }

  s = "G10C";
  x = (TGeoMixture*)GetMat(s);
  if(!x){
    x = new TGeoMixture(s,4,   1.70000    );
    x->SetUniqueID(  27);
    x->DefineElement(0,28.09,14,0.53);
    x->DefineElement(1,16.,8,0.3);
    x->DefineElement(2,12.01,6,0.15);
    x->DefineElement(3,1.01,1,0.2000000E-01);
  }

  TGeoMedium *n=0;
  s="ALUMINIUM";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,1,9,-1,1,40,1,100,0.5000000E-01,0.136283,0.5000000E-03);

  s = "N2 GAS";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,3,19,-1,1,40,1,0.5000000E-01,0.5000000E-01,0.1000000E-02,0.5000000E-03);
  
  s = "KAPTON";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,6,17,1,1,40,1,100,0.5000000E-01,0.6000012E-04,0.5000000E-03); 

  s = "SICALO";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,11,21,1,1,40,1,100,0.5000000E-01,0.3800000E-03,0.5000000E-03);
  
  s = "TUNGA";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,15,25,-1,1,40,1,100,0.5000000E-01,0.2630000E-02,0.5000000E-03);
  
  s ="KAOLINITE";
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,16,26,-1,1,40,1,100,0.5000000E-01,0.5000000E-04,0.5000000E-03);
  
  s = "G10C";  
  n = (GetMed(s))?GetMed(s): new TGeoMedium(s,17,27,-1,1,40,1,100,0.5000000E-01,0.1200000E-02,0.5000000E-03);


  TGeoVolume *v=0;

  s = "CALB";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),23.2,23.2,10.589);
  s = "CALS";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("ALUMINIUM"),24.2,24.2,10.639);
  s = "CAPL";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),12.3,12.3,0.19E-01);
  s = "CANS";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("N2 GAS"),12.3,12.3,0.7E-01);
  s = "CASI";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SICALO"),3.904,3.904,0.19E-01);
  s = "C10C";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("G10C"),12.3,12.3,0.6E-01);
  s = "CAAB";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("TUNGA"),12.3,12.3,0.1315);
  s = "CAKA";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("KAOLINITE"),12.3,12.3,0.25E-02);
  s = "CAKP";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("KAPTON"),12.3,12.3,0.25E-02);
  s = "CAGL";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SICALO"),12.3,12.3,0.5E-02);
  //=====//
  s = "CAST";
  v = (GetVol(s))?GetVol(s): gGeoManager->MakeBox(s,GetMed("SICALO"),3.904,0.122,0.19E-01);
  //=====//

  GetVol("CALS")->AddNode(GetVol("CALB"),1,new TGeoTranslation(0.,0.,0.5E-01));
   GetVol("CALB")->AddNode(GetVol("CAPL"),1,new TGeoTranslation(0.1,-0.5E-01,9.876));
    GetVol("CAPL")->AddNode(GetVol("CASI"),1,new TGeoTranslation(-8.05,-8.05,0.));
    //====//
    for (Int_t i=0; i<32; i++){
    GetVol("CASI")->AddNode(GetVol("CAST"),i, new TGeoTranslation(0.,-3.782+0.244*i,0.));
    }
    //====//
    GetVol("CAPL")->AddNode(GetVol("CASI"),2,new TGeoTranslation(0.,-8.05,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),3,new TGeoTranslation(8.05,-8.05,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),4,new TGeoTranslation(-8.05,0.,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),5,gGeoIdentity);
    GetVol("CAPL")->AddNode(GetVol("CASI"),6,new TGeoTranslation(8.05,0.,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),7,new TGeoTranslation(-8.05,8.05,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),8,new TGeoTranslation(0.,8.05,0.));
    GetVol("CAPL")->AddNode(GetVol("CASI"),9,new TGeoTranslation(8.05,8.05,0.));
   GetVol("CALB")->AddNode(GetVol("CANS"),1,new TGeoTranslation(0.,-0.1,9.787));
    GetVol("CANS")->AddNode(GetVol("CAKA"),1,new TGeoTranslation(0.,0.,-0.675E-01));
    GetVol("CANS")->AddNode(GetVol("C10C"),1,new TGeoTranslation(0.,0.,-0.5E-02));
    GetVol("CANS")->AddNode(GetVol("CAGL"),1,new TGeoTranslation(0.,0.,0.6E-01));
    GetVol("CANS")->AddNode(GetVol("CAKP"),1,new TGeoTranslation(0.,0.,0.675E-01));

   GetVol("CALB")->AddNode(GetVol("CAAB"),1,new TGeoTranslation(0.,-0.1,9.5855));
   GetVol("CALB")->AddNode(GetVol("CANS"),2,new TGeoCombiTrans(0.,-0.1,9.384,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),2,new TGeoCombiTrans(0.5E-01,0.,9.295,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),3,new TGeoTranslation(-0.1,-0.15,9.067));
   GetVol("CALB")->AddNode(GetVol("CANS"),3,new TGeoTranslation(0.,-0.1,8.978));
   GetVol("CALB")->AddNode(GetVol("CAAB"),2,new TGeoTranslation(0.,-0.1,8.7765));
   GetVol("CALB")->AddNode(GetVol("CANS"),4,new TGeoCombiTrans(0.,-0.1,8.575,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),4,new TGeoCombiTrans(-0.5E-01,-0.2,8.486,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),5,new TGeoTranslation(0.1,-0.5E-01,8.058));
   GetVol("CALB")->AddNode(GetVol("CANS"),5,new TGeoTranslation(0.,-0.1,7.969));
   GetVol("CALB")->AddNode(GetVol("CAAB"),3,new TGeoTranslation(0.,-0.1,7.7675));
   GetVol("CALB")->AddNode(GetVol("CANS"),6,new TGeoCombiTrans(0.,-0.1,7.566,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),6,new TGeoCombiTrans(0.5E-01,0.,7.477,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),7,new TGeoTranslation(-0.1,-0.15,7.249));
   GetVol("CALB")->AddNode(GetVol("CANS"),7,new TGeoTranslation(0.,-0.1,7.16));
   GetVol("CALB")->AddNode(GetVol("CAAB"),4,new TGeoTranslation(0.,-0.1,6.9585));
   GetVol("CALB")->AddNode(GetVol("CANS"),8,new TGeoCombiTrans(0.,-0.1,6.757,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),8,new TGeoCombiTrans(-0.5E-01,-0.2,6.668,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),9,new TGeoTranslation(0.1,-0.5E-01,6.24));
   GetVol("CALB")->AddNode(GetVol("CANS"),9,new TGeoTranslation(0.,-0.1,6.151));
   GetVol("CALB")->AddNode(GetVol("CAAB"),5,new TGeoTranslation(0.,-0.1,5.9495));
   GetVol("CALB")->AddNode(GetVol("CANS"),10,new TGeoCombiTrans(0.,-0.1,5.748,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),10,new TGeoCombiTrans(0.5E-01,0.,5.659,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),11,new TGeoTranslation(-0.1,-0.15,5.431));
   GetVol("CALB")->AddNode(GetVol("CANS"),11,new TGeoTranslation(0.,-0.1,5.342));
   GetVol("CALB")->AddNode(GetVol("CAAB"),6,new TGeoTranslation(0.,-0.1,5.1405));
   GetVol("CALB")->AddNode(GetVol("CANS"),12,new TGeoCombiTrans(0.,-0.1,4.939,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),12,new TGeoCombiTrans(-0.5E-01,-0.2,4.85,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),13,new TGeoTranslation(0.1,-0.5E-01,4.422));
   GetVol("CALB")->AddNode(GetVol("CANS"),13,new TGeoTranslation(0.,-0.1,4.333));
   GetVol("CALB")->AddNode(GetVol("CAAB"),7,new TGeoTranslation(0.,-0.1,4.1315));
   GetVol("CALB")->AddNode(GetVol("CANS"),14,new TGeoCombiTrans(0.,-0.1,3.93,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),14,new TGeoCombiTrans(0.5E-01,0.,3.841,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),15,new TGeoTranslation(-0.1,-0.15,3.613));
   GetVol("CALB")->AddNode(GetVol("CANS"),15,new TGeoTranslation(0.,-0.1,3.524));
   GetVol("CALB")->AddNode(GetVol("CAAB"),8,new TGeoTranslation(0.,-0.1,3.3225));
   GetVol("CALB")->AddNode(GetVol("CANS"),16,new TGeoCombiTrans(0.,-0.1,3.121,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),16,new TGeoCombiTrans(-0.5E-01,-0.2,3.032,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),17,new TGeoTranslation(0.1,-0.5E-01,2.604));
   GetVol("CALB")->AddNode(GetVol("CANS"),17,new TGeoTranslation(0.,-0.1,2.515));
   GetVol("CALB")->AddNode(GetVol("CAAB"),9,new TGeoTranslation(0.,-0.1,2.3135));
   GetVol("CALB")->AddNode(GetVol("CANS"),18,new TGeoCombiTrans(0.,-0.1,2.112,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),18,new TGeoCombiTrans(0.5E-01,0.,2.023,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),19,new TGeoTranslation(-0.1,-0.15,1.795));
   GetVol("CALB")->AddNode(GetVol("CANS"),19,new TGeoTranslation(0.,-0.1,1.706));
   GetVol("CALB")->AddNode(GetVol("CAAB"),10,new TGeoTranslation(0.,-0.1,1.5045));
   GetVol("CALB")->AddNode(GetVol("CANS"),20,new TGeoCombiTrans(0.,-0.1,1.303,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),20,new TGeoCombiTrans(-0.5E-01,-0.2,1.214,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),21,new TGeoTranslation(0.1,-0.5E-01,0.786));
   GetVol("CALB")->AddNode(GetVol("CANS"),21,new TGeoTranslation(0.,-0.1,0.697));
   GetVol("CALB")->AddNode(GetVol("CAAB"),11,new TGeoTranslation(0.,-0.1,0.4955));
   GetVol("CALB")->AddNode(GetVol("CANS"),22,new TGeoCombiTrans(0.,-0.1,0.294,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),22,new TGeoCombiTrans(0.5E-01,0.,0.205,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),23,new TGeoTranslation(-0.1,-0.15,-0.23E-01));
   GetVol("CALB")->AddNode(GetVol("CANS"),23,new TGeoTranslation(0.,-0.1,-0.112));
   GetVol("CALB")->AddNode(GetVol("CAAB"),12,new TGeoTranslation(0.,-0.1,-0.3135));
   GetVol("CALB")->AddNode(GetVol("CANS"),24,new TGeoCombiTrans(0.,-0.1,-0.515,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),24,new TGeoCombiTrans(-0.5E-01,-0.2,-0.604,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),25,new TGeoTranslation(0.1,-0.5E-01,-1.032));
   GetVol("CALB")->AddNode(GetVol("CANS"),25,new TGeoTranslation(0.,-0.1,-1.121));
   GetVol("CALB")->AddNode(GetVol("CAAB"),13,new TGeoTranslation(0.,-0.1,-1.3225));
   GetVol("CALB")->AddNode(GetVol("CANS"),26,new TGeoCombiTrans(0.,-0.1,-1.524,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),26,new TGeoCombiTrans(0.5E-01,0.,-1.613,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),27,new TGeoTranslation(-0.1,-0.15,-1.841));
   GetVol("CALB")->AddNode(GetVol("CANS"),27,new TGeoTranslation(0.,-0.1,-1.93));
   GetVol("CALB")->AddNode(GetVol("CAAB"),14,new TGeoTranslation(0.,-0.1,-2.1315));
   GetVol("CALB")->AddNode(GetVol("CANS"),28,new TGeoCombiTrans(0.,-0.1,-2.333,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),28,new TGeoCombiTrans(-0.5E-01,-0.2,-2.422,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),29,new TGeoTranslation(0.1,-0.5E-01,-2.85));
   GetVol("CALB")->AddNode(GetVol("CANS"),29,new TGeoTranslation(0.,-0.1,-2.939));
   GetVol("CALB")->AddNode(GetVol("CAAB"),15,new TGeoTranslation(0.,-0.1,-3.1405));
   GetVol("CALB")->AddNode(GetVol("CANS"),30,new TGeoCombiTrans(0.,-0.1,-3.342,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),30,new TGeoCombiTrans(0.5E-01,0.,-3.431,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),31,new TGeoTranslation(-0.1,-0.15,-3.659));
   GetVol("CALB")->AddNode(GetVol("CANS"),31,new TGeoTranslation(0.,-0.1,-3.748));
   GetVol("CALB")->AddNode(GetVol("CAAB"),16,new TGeoTranslation(0.,-0.1,-3.9495));
   GetVol("CALB")->AddNode(GetVol("CANS"),32,new TGeoCombiTrans(0.,-0.1,-4.151,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),32,new TGeoCombiTrans(-0.5E-01,-0.2,-4.24,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),33,new TGeoTranslation(0.1,-0.5E-01,-4.668));
   GetVol("CALB")->AddNode(GetVol("CANS"),33,new TGeoTranslation(0.,-0.1,-4.757));
   GetVol("CALB")->AddNode(GetVol("CAAB"),17,new TGeoTranslation(0.,-0.1,-4.9585));
   GetVol("CALB")->AddNode(GetVol("CANS"),34,new TGeoCombiTrans(0.,-0.1,-5.16,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),34,new TGeoCombiTrans(0.5E-01,0.,-5.249,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),35,new TGeoTranslation(-0.1,-0.15,-5.477));
   GetVol("CALB")->AddNode(GetVol("CANS"),35,new TGeoTranslation(0.,-0.1,-5.566));
   GetVol("CALB")->AddNode(GetVol("CAAB"),18,new TGeoTranslation(0.,-0.1,-5.7675));
   GetVol("CALB")->AddNode(GetVol("CANS"),36,new TGeoCombiTrans(0.,-0.1,-5.969,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),36,new TGeoCombiTrans(-0.5E-01,-0.2,-6.058,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),37,new TGeoTranslation(0.1,-0.5E-01,-6.486));
   GetVol("CALB")->AddNode(GetVol("CANS"),37,new TGeoTranslation(0.,-0.1,-6.575));
   GetVol("CALB")->AddNode(GetVol("CAAB"),19,new TGeoTranslation(0.,-0.1,-6.7765));
   GetVol("CALB")->AddNode(GetVol("CANS"),38,new TGeoCombiTrans(0.,-0.1,-6.978,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),38,new TGeoCombiTrans(0.5E-01,0.,-7.067,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),39,new TGeoTranslation(-0.1,-0.15,-7.295));
   GetVol("CALB")->AddNode(GetVol("CANS"),39,new TGeoTranslation(0.,-0.1,-7.384));
   GetVol("CALB")->AddNode(GetVol("CAAB"),20,new TGeoTranslation(0.,-0.1,-7.5855));
   GetVol("CALB")->AddNode(GetVol("CANS"),40,new TGeoCombiTrans(0.,-0.1,-7.787,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),40,new TGeoCombiTrans(-0.5E-01,-0.2,-7.876,GetRot("rot3")));

   GetVol("CALB")->AddNode(GetVol("CAPL"),41,new TGeoTranslation(0.1,-0.5E-01,-8.304));
   GetVol("CALB")->AddNode(GetVol("CANS"),41,new TGeoTranslation(0.,-0.1,-8.393));
   GetVol("CALB")->AddNode(GetVol("CAAB"),21,new TGeoTranslation(0.,-0.1,-8.5945));
   GetVol("CALB")->AddNode(GetVol("CANS"),42,new TGeoCombiTrans(0.,-0.1,-8.796,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),42,new TGeoCombiTrans(0.5E-01,0.,-8.885,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL"),43,new TGeoTranslation(-0.1,-0.15,-9.113));
   GetVol("CALB")->AddNode(GetVol("CANS"),43,new TGeoTranslation(0.,-0.1,-9.202));
   GetVol("CALB")->AddNode(GetVol("CAAB"),22,new TGeoTranslation(0.,-0.1,-9.4035));
   GetVol("CALB")->AddNode(GetVol("CANS"),44,new TGeoCombiTrans(0.,-0.1,-9.605,GetRot("rot3")));
   GetVol("CALB")->AddNode(GetVol("CAPL") ,44,new TGeoCombiTrans(-0.5E-01,-0.2,-9.694,GetRot("rot3")));



   SetMotherProp(GetVol("CALS"),1,new TGeoTranslation(0.,0.,13.05));

}


void  PamVMCDetCalo::DefineCuts(){

  TString  s ="ALUMINIUM"; // default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
  SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));
  s ="N2 GAS";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
                             0.001, 0.01, 1., 1., 1., 0., 0., 1., 1., 4., 1., 1., 2., 1.));
  s = "IRON";  //default GPAMELA parameters
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
  s = "KAPTON"; // default GPAMELA parameters scintillator?
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.0001, 0.001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001, 0.0001,
			     0.001, 0.01, 1., 1., 1., 0., 1., 1., 1., 4., 1., 1., 1., 1.));   
  s = "SICALO";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));
  s = "TUNGA";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));
  s = "KAOLINITE";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));
  s = "G10C";
  if (GetMed(s) && !GetCC(s))
    SetCC(s, new pCutControl(GetMedID(s), 0.00001, 0.00001, 0.00001, 0.00001, 0.001, 0.001, 0.01, 0.00001,
                             0.00001, 0.01, 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1., 2.));

}

