#ifndef PAMVMCCALOSD_H
#define PAMVMCCALOSD_H
#include <iostream>

#include "PamVMCDetectorSD.h"

#define NOCALHIT 4224

using std::cout;
using std::endl;

class PamVMCCaloSD: public PamVMCDetectorSD{


public:
  PamVMCCaloSD(): PamVMCDetectorSD("PamVMCDetectorHit","CAST",NOCALHIT){
    
  }


  virtual void FillHit(fin f,TVirtualMC *g, Bool_t is_prim){ 

    switch(f) {
    case ENTERING:
      CleanHit();
      FillVolID();
      InitHit();
       
    default:
      UpdateHit(g, is_prim);
      break;      
    }

    switch(f){
    case EXITING:
      
       // Save hit if energy release is greater than zero 
      if(fhit->GetEREL()){
	if(fdetID->FillVolID()){
	  
	  SaveHit(fdetID->GetID( ));
	  
		} else {
	  cout << "Calorimeter FillVolID false" <<endl; 
	}
      }
      break;
    default:
      break;
    }
  }

  Int_t GetPlaneID(){
    return ((int)fhit->GetPOS()/192);
  }

  Int_t GetViewID(){
    return ((int)fhit->GetPOS()/96%2==0?0:1);
  }
  Int_t GetStripID(){
    return (fhit->GetPOS()%96);
  }

 

  ClassDef(PamVMCCaloSD,1)

};

#endif // PAMVMCCALOSD_H
