#ifndef PAMVMCCARDID_H
#define PAMVMCCARDID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define CARDOF 1

using std::cout;
using std::endl;

struct pCardID: public pGeoID {
  Int_t plNo;
 

  pCardID(): plNo(-1) {};
  pCardID(Int_t offset): pGeoID(offset), plNo(-1) {};
  pCardID & operator = (const pCardID &pid) {
    plNo=pid.plNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      	gMC->CurrentVolOffID(2,plNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return plNo; }

  void Print(const Option_t* ="") const { 
    cout << " pCardID : plNo " << plNo <<endl;
  }

};


#endif // PAMVMCCardID_H
