#ifndef PAMVMCCASID_H
#define PAMVMCCASID_H
#include <iostream>
#include "TVirtualMC.h"
#include "pGeoID.h"

#define CASOF 1

using std::cout;
using std::endl;

struct pCasID: public pGeoID {
  Int_t plNo;
 

  pCasID(): plNo(-1) {};
  pCasID(Int_t offset): pGeoID(offset), plNo(-1) {};
  pCasID & operator = (const pCasID &pid) {
    plNo=pid.plNo;
    return *this;
  }

  Bool_t FillVolID(){
    Bool_t t=kFALSE;
    if(gMC) {
      	gMC->CurrentVolOffID(3,plNo);
      	t= kTRUE;
    }
    return t;
  }

  Int_t GetID() const { return plNo; }

  void Print(const Option_t* ="") const { 
    cout << " pCasID : plNo " << plNo <<endl;
  }

};


#endif // PAMVMCCasID_H
