#ifndef PAMVMCSDMGR_H
#define PAMVMCSDMGR_H
#include <iostream>

#include "TString.h"
#include "TObjString.h"
#include "TMap.h"
#include "PamVMCDetectorSD.h"


class PamVMCSDMgr: public TObject {

 private:

  static PamVMCSDMgr * fsd;
  TMap fsdmap;

 protected:
  PamVMCSDMgr() {;};

 public:
  
  static PamVMCSDMgr * Instance();

  ~PamVMCSDMgr() {fsdmap.DeleteAll();};

  PamVMCDetectorSD * GetSD(const char *name){
    return (PamVMCDetectorSD*)fsdmap(name);
  }

  void SetSD(const char *name, PamVMCDetectorSD *detSD){
    fsdmap.Add(new TObjString(name),detSD);
  }

  void Register(){
      //  std::cout <<" Into Register() " << std::endl;
      TMapIter *n= (TMapIter *)fsdmap.MakeIterator(); 
      TObject *o; while(( o=(TObject *) n->Next())) { 
        //cout<<"!!KEY=<<"<< endl;
	((PamVMCDetectorSD *)fsdmap.GetValue(o))->Register();
      }
  }

  void Clear(const Option_t* =""){
    TMapIter *n= (TMapIter *)fsdmap.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
    ((PamVMCDetectorSD *)fsdmap.GetValue(o))->ClearHitColl();
    }
  }

  void Compress(const Option_t* =""){
    TMapIter *n= (TMapIter *)fsdmap.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
    ((PamVMCDetectorSD *)fsdmap.GetValue(o))->Compress();
    }
  }


  void PreEvent(const Option_t* =""){
    TMapIter *n= (TMapIter *)fsdmap.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
    ((PamVMCDetectorSD *)fsdmap.GetValue(o))->PreEvent();
    }
  }

  void Digitize(const Option_t* =""){
    TMapIter *n= (TMapIter *)fsdmap.MakeIterator(); 
    TObject *o; while( (o=(TObject *) n->Next())) { 
    ((PamVMCDetectorSD *)fsdmap.GetValue(o))->Digitize();
    }
  }


  void Print( const Option_t* ="") const { 
    cout << "PamVMCSDMgr, list of SD stored " << endl;
    fsdmap.Print();
  }

};

#endif
