void run_g4_test() {

    TString PAM_VMC=gSystem->Getenv("PAM_VMC");
    TString PLAT=gSystem->Getenv("PLATFORM");

    // Load basic libraries
    gROOT->LoadMacro(PAM_VMC+"/macro/basiclibs.C");
    basiclibs();

    // Load PAMELA libs
    TString PAMLIB=gSystem->Getenv("PAM_LIB");
    gSystem->Load(PAMLIB+"/libyoda.so");
    gSystem->Load(PAMLIB+"/libDarthVader.so");
    gSystem->Load(PAMLIB+"/libPamLevel2.so");
    
    // Load Geant4 libraries
    gROOT->LoadMacro(PAM_VMC+"/macro/PamG4Libs.C");
    PamG4Libs();
  
    // Load application library
    gSystem->Load(PAM_VMC+"/lib/tgt_"+PLAT+"/libPamVMC_fc");    

    // MC application
    PamVMCApplication* appl 
      = new PamVMCApplication("PAMG4_VMC", "PAMELA GEANT4 VMC application","nik1");
  
    //verbose level (0-4), 0 means no verbose 
    appl->SetVerboseLevel(0);

    //initialise physycs with specific RunConfiguration, defined in macro
    appl->InitMC(PAM_VMC+"/config/g4Config.C");

 
    //additional flags and controls related to G4 core
   ((TGeant4*)gMC)->ProcessGeantMacro(PAM_VMC+"/config/g4config2.in");


    //maximum allowed steps per track, default 30000
    ((TGeant4*)gMC)->SetMaxNStep(50000);

    //define particle. Important. Is shold be done before any
    //definition of energy or momentum
    appl->GetPrimaryGenerator()->SetParticle(1000020040);

    //define direction, theta, phi (radians)
    appl->GetPrimaryGenerator()->SetDirection(-TMath::Pi()/180.*0.,
    					      TMath::Pi()/90.*0.);

    //define total kinetic energy (GeV)
    appl->GetPrimaryGenerator()->SetKinEnergy(8.);

    //define initial position in PAMELA reference system
    appl->GetPrimaryGenerator()->SetPosition(2.,2.,120.);


    //run MC in loop and visualize for 1 evnent
    for (Int_t i=0; i<11; i++){
     if (i==10) ((TGeant4*)gMC)->ProcessGeantMacro(PAM_VMC+"/config/g4vis.in");
     appl->RunMC(1);
    }

    //Starting Geant-4 interface if needed
    //((TGeant4*)gMC)->StartGeantUI();

    // finish run, write output files
    appl->FinishRun();
    delete appl;
}  
