#ifndef PAMVMCVOLCRMGR_H
#define PAMVMCVOLCRMGR_H
#include <iostream>

#include "TString.h"
#include "TObjString.h"
#include "TMap.h"
#include "PamVMCVolCross.h"


class PamVMCVolCrossMgr: public TObject {

 private:

  static PamVMCVolCrossMgr * fcrm;
  TMap fvolmap;
  Bool_t fGood;


 protected:
  
  PamVMCVolCrossMgr();

 public:

  ~PamVMCVolCrossMgr() {fvolmap.DeleteAll();};
  
  static PamVMCVolCrossMgr * Instance();

  PamVMCVolCross * GetSD(const char *name){
    return (PamVMCVolCross*)fvolmap(name);
  }

  Bool_t IsTrackGood();
  
  void Reset();

  void Print( const Option_t* ="") const { 
    cout << "PamVMCVolumes Special Crossing " << endl;
    fvolmap.Print();
  }

};

#endif
