#ifndef PAMVMCGEOID_H
#define PAMVMCGEOID_H
#include "TString.h"
#include "PamVMCGeoIDMgr.h"

 
class PamVMCGeoID : public TObject {

 protected:

  TString fvolname;
  pGeoID *fgid;

 public:

  PamVMCGeoID(): fvolname("none"), fgid(0) {};
  PamVMCGeoID(const char *vname): 
    fvolname(vname) {
    fgid=PamVMCGeoIDMgr::Instance()->GetGeoID(fvolname.Data());
  }


  virtual ~PamVMCGeoID(){};

  virtual Bool_t FillVolID() { return fgid->FillVolID();}  
  virtual Int_t GetID() { return fgid->GetID();} 
  void SetVolName(const char *vname) {fvolname=vname;}
  const char *GetVolName() { return fvolname.Data();}

  Int_t GetVolOffset() { return fgid->fvoffset;}

  void Print(const Option_t* ="") const { 
    // Will see .... // 
    fgid->Print();
  };
 
};

#endif //PAMVMCGEOID_H
