#ifndef PAMG4_REGION_CONSTRUCTION_H
#define PAMG4_REGION_CONSTRUCTION_H

#include <G4LogicalVolume.hh>
#include <TG4VUserRegionConstruction.h>

#include "TG4Globals.h"


class PamG4RegionConstruction: public TG4VUserRegionConstruction
{
  public:
    PamG4RegionConstruction(const G4String& name = "Range cuts");
    PamG4RegionConstruction(G4int verboseLevel,
                              const G4String& name = "Range cuts");

    virtual ~PamG4RegionConstruction() {; };

    virtual void Construct(); 

  protected:
    
    void LoopDaughters(G4LogicalVolume * vol);
    void SetCuts(G4LogicalVolume * vol);
  
 private:

    G4String fname;
    G4int fverboselevel;
};  
#endif //PAMG4_REGION_CONSTRUCTION_H

