#include <iostream>
#include <fstream>
#include <stdio.h>
//#include <vector.h>
#include <math.h>
#include <TH1F.h>
#include <TH2F.h>
#include <TH1D.h>
#include <TH2D.h>
#include <TFile.h>
#include <TROOT.h>
#include <TList.h>
#include <TString.h>
//#include <TObjectString.h>
#include <TGraphAsymmErrors.h>
#include <TGraphErrors.h>
#include <TChain.h>
#include <TCutG.h>
#include <TF1.h>
#include <TCanvas.h>
#include <TObjString.h>
#include <TMath.h>
#include <Math/GSLRndmEngines.h>
#include <TRandom3.h>


#ifndef RANGEN_H
#define RANGEN_H

using std::vector;

class RanGen: public TRandom3{
 public:

  RanGen(Int_t seed=0);
  ~RanGen();

  Double_t Gamma(Int_t n, Double_t theta);
  vector<Double_t> Dirichlet(Int_t n, vector<Int_t> x);
  vector<Int_t> Multinomial(Int_t n, vector<Double_t> p);
  Int_t Binomial(Int_t n, Double_t p);
  Double_t Beta(const Int_t a, const Int_t b);


  // private:

  ClassDef(RanGen, 1);
};

#endif
