
#ifndef DetectorConstruction_h
#define DetectorConstruction_h 1

#include "G4VUserDetectorConstruction.hh"
#include "globals.hh"

class G4VPhysicalVolume;
class G4Box;
class G4Tubs;
class G4Trd;
class G4LogicalVolume;

class DetectorConstruction : public G4VUserDetectorConstruction
{
  public:
    DetectorConstruction();
    ~DetectorConstruction();

  public:
  
     G4VPhysicalVolume* Construct();
public:
  
  G4double GetWorld_Z()        {return World_Z;};
  G4double GetWorld_XY()       {return World_XY;};
  G4double GetCalor_XY()       {return Calor_XY;};
  G4double GetCalorThickness() {return CalorTh;};

private: 
  G4Box* solidWorld; 

  G4Box* solidAbsorber;
  G4Box* solidPcb;
  G4Box* solidSiLayerY;
  G4Box* solidSiLayerX;
  G4Box* solidStrPlateY;
  G4Box* solidStrPlateX;
  G4Box* solidStrX_L;
  G4Box* solidStrY_L;

  G4Box* solidS1;
  G4Box* solidS2;
  G4Box* solidS3;
  G4Box* solidS4;
  G4Box* solidCAT;
  G4Box* solidCAT1;
  G4Box* solidCASX;
  G4Box* solidCASY;
  G4Box* solidAl;
  G4Trd* solidCARD;
  G4Trd* solidCARD1;

  G4Box* solidMag;
  G4Box* solidMagAir;
  G4Box* solidMagSiLayer;
  G4Box* solidMagSiPlate;

    G4Box*  solidPol; 
    G4Tubs * He3Ar_tubs;
    G4Tubs * Fe_tubs;
  //---------------------------------------------------------------
  G4LogicalVolume* logicWorld;

  G4LogicalVolume* logicAbsorber;
  G4LogicalVolume* logicPcb;
  G4LogicalVolume* logicSiLayerY;
  G4LogicalVolume* logicSiLayerX;
  G4LogicalVolume* logicStrPlateY;
  G4LogicalVolume* logicStrPlateX;
  G4LogicalVolume* logicStrX_L;
  G4LogicalVolume* logicStrY_L;

  G4LogicalVolume* logicS1;
  G4LogicalVolume* logicS2;
  G4LogicalVolume* logicS3;
  G4LogicalVolume* logicS4;
  G4LogicalVolume* logicCAT;
  G4LogicalVolume* logicCAT1;
  G4LogicalVolume* logicCASX;
  G4LogicalVolume* logicCASY;
  G4LogicalVolume* logicCARD;
  G4LogicalVolume* logicCARD1;

  G4LogicalVolume* logicAl;

  G4LogicalVolume* logicMag;
  G4LogicalVolume* logicMagAir;
  G4LogicalVolume* logicMagSiLayer;
  G4LogicalVolume* logicMagSiPlate;

  G4LogicalVolume* logicPol;
  G4LogicalVolume*  He3Ar_log;
  G4LogicalVolume*  Fe_log;
  //--------------------------------------------------------------------
  G4VPhysicalVolume* physiWorld;

  G4VPhysicalVolume* physiStrPlateY;
  G4VPhysicalVolume* physiStrPlateX;
  G4VPhysicalVolume* physiStrY_L;
  G4VPhysicalVolume* physiStrX_L;
  G4VPhysicalVolume* physiAbsorber;
  G4VPhysicalVolume* physiPcb;
  G4VPhysicalVolume* physiSiLayerY;
  G4VPhysicalVolume* physiSiLayerX;

  G4VPhysicalVolume* physiS1;
  G4VPhysicalVolume* physiS2;
  G4VPhysicalVolume* physiS3;
  G4VPhysicalVolume* physiS4;
  G4VPhysicalVolume* physiCAT;
  G4VPhysicalVolume* physiCAT1;
  G4VPhysicalVolume* physiCARD;
  G4VPhysicalVolume* physiCARD1;
  G4VPhysicalVolume* physiCASX;
  G4VPhysicalVolume* physiCASY;

  G4VPhysicalVolume* physiAl;
  G4VPhysicalVolume* physiPol;

  G4VPhysicalVolume* physiMag;
  G4VPhysicalVolume* physiMagAir;
  G4VPhysicalVolume* physiMagSiLayer;
  G4VPhysicalVolume* physiMagSiPlate;

  G4VPhysicalVolume* physiHe3Ar;
  G4VPhysicalVolume* physiFe;

G4double CalorSTh;
G4double CalorTh;
G4double Calor_XY;
G4double World_Z;
G4double World_XY;
G4double PcbTh;
G4double AbsorberTh;  
G4double  SiLayerTh;

};

#endif


// 2005 by G.I.Vasilyev
