

#include "SteppingActionMessenger.hh"
#include "SteppingAction.hh"

#include "globals.hh"
#include "G4UIdirectory.hh"
#include "G4UIcmdWithABool.hh"

SteppingActionMessenger::SteppingActionMessenger(SteppingAction* SA)
:SteppingAct(SA)
{
  stepDirectory = new G4UIdirectory("/step/");
  stepDirectory->SetGuidance("Step draw control command.");

  drawStepCmd = new G4UIcmdWithABool("/step/draw",this);
  drawStepCmd->SetGuidance("Draw each step on the fly. (default = true)");
  drawStepCmd->SetParameterName("draw", true);
  drawStepCmd->SetDefaultValue(true);
}

void SteppingActionMessenger::SetNewValue(G4UIcommand* command, G4String newValues)
{
  if( command->GetCommandName() == "draw" )
  {
    G4int vl;
    const char* t = newValues;
    std::istrstream is((char*)t);
    is >> vl;
    SteppingAct->SetDrawFlag(vl!=0);
  }
}

// 2005 by G.I.Vasilyev
