
#include "EventAction.hh"
#include "RunAction.hh"
#include "G4Run.hh"
#include "G4Event.hh"
#include "G4EventManager.hh"
#include "G4HCofThisEvent.hh"
#include "G4VVisManager.hh"r
#include "G4UImanager.hh"
#include "G4ios.hh"
#include "G4UnitsTable.hh"


EventAction::EventAction(RunAction* run): printModulo(1),
							 myRU(run)
{;}

EventAction::~EventAction()
{;}

void EventAction::BeginOfEventAction(const G4Event* evt)
{
 G4int evtNb = evt->GetEventID();
 if (evtNb%printModulo == 0)
   { 
    G4cout << "\n---> Begin of event: " << evtNb << G4endl;
   };
 myRU->noOfNeutrons=0;
 for(G4int i=0;i<36;i++){   
       myRU->Etube[i]=0.;
       myRU->E1tube[i]=0.;
       myRU->TimeTube[i]=0.;
       myRU->tube[i]=0;		  
   }
	 
 }


void EventAction::EndOfEventAction(const G4Event* evt)
{
  // G4int evtNb = evt->GetEventID();

 for(G4int i=0;i<36;i++)
   {
     if(myRU->Etube[i]/keV > 200.) myRU->noOfNeutrons++;
     if(myRU->E1tube[i]/keV > 200.)  myRU->noOfNeutrons++;
       }
 myRU->N += myRU->noOfNeutrons;
 G4cout << "neutron "<<myRU->noOfNeutrons <<" N="<<myRU->N<<G4endl;

 // std::ofstream fileOut;
 // fileOut.open("nomber.dat",std::ios::app);
 // fileOut << noOfNeutrons <<" "<<evtNb<<G4endl;
 //fileOut.close();

}


// 2005 by G.I.Vasilyev
