#include "DetectorConstruction.hh"
#include "G4Material.hh"
#include "G4Element.hh"
#include "G4UnitsTable.hh"
#include "G4MaterialTable.hh"
#include "G4Box.hh"
#include "G4Tubs.hh"
#include "G4Trd.hh"
#include "G4PVPlacement.hh"
#include "G4RunManager.hh"
#include "G4VisAttributes.hh"
#include "G4Colour.hh"
#include "G4ios.hh"

#include "G4Transform3D.hh"
#include "G4RotationMatrix.hh"
#include "G4FieldManager.hh"
#include "G4UniformMagField.hh"
#include "G4Mag_UsualEqRhs.hh"
#include "G4MagIntegratorStepper.hh"
#include "G4ChordFinder.hh"
#include "G4ClassicalRK4.hh"

DetectorConstruction::DetectorConstruction()
{
  CalorSTh = .759*cm;
  CalorTh =11*(2.*CalorSTh+0.2*cm);
  Calor_XY = 24.3*cm;
  World_Z =  190.*cm;    
  World_XY = 48.2*cm; 
  PcbTh = 0.583*cm;
  AbsorberTh = 0.263*cm;
  SiLayerTh =0.38*mm;
}

DetectorConstruction::~DetectorConstruction()
{ }


G4VPhysicalVolume* DetectorConstruction::Construct()
{ 
 
G4String name, symbol;                
G4double a, z,density,fractionmass,pressure,temperature, abundance;                 
    
 G4int ncomponents,     // n components
   iz,                  // number of protons
   in,                  // number of nucleons
   natoms;

a = 1.01*g/mole;
G4Element* H  = new G4Element(name="Hydrogen",symbol="H" , z= 1., a);
 
G4Isotope* He3is =  new G4Isotope(name="He3i", iz=2, in=3, a=3.01603*g/mole);
G4Element* He3el  = new G4Element(name="Helium3",symbol="He3el",ncomponents=1);
He3el->AddIsotope(He3is, abundance= 1);

 a = 39.948*g/mole;
 G4Element* Arel  = new G4Element(name="Argon",symbol="Ar" , z= 18., a);

  a = 10.81*g/mole;
  G4Element* Bel  = new G4Element(name="Boron",symbol="B" , z= 5., a);

  // a = 144.2*g/mole;
  //  G4Element* Ndel  = new G4Element(name="Neodymium",symbol="Nd" , z= 60., a);
   
 a = 26.98*g/mole;  
 G4Element* Alumin = new G4Element(name="Aluminum"  ,symbol="Al" , z= 13., a);
 density = 2.700*g/cm3;

 G4Material* Al = new G4Material(name="Aluminum", density, ncomponents=1);
 Al->AddElement(Alumin, fractionmass=1.);
 
 a = 12.01*g/mole;
 G4Element* C  = new G4Element(name="Carbon"  ,symbol="C" , z= 6., a);

a = 14.01*g/mole;
G4Element* N  = new G4Element(name="Nitrogen",symbol="N" , z= 7., a);
 
 a = 16.00*g/mole;
G4Element* O  = new G4Element(name="Oxygen"  ,symbol="O" , z= 8., a);
 
a = 183.85*g/mole;
G4Element* W = new G4Element(name="Tungsten"    ,symbol="W", z=74., a);

a = 58.71*g/mole;
G4Element* Ni = new G4Element(name="Nickel"    ,symbol="Ni", z=28., a);
  
a = 63.55*g/mole;
G4Element* Cu = new G4Element(name="Copper"    ,symbol="Cu", z=26., a);

 a=55.85*g/mole;
G4Element* Fe = new G4Element(name="Iron"  ,symbol="Fe" , z= 26., a);  

G4Material* metallFe = new G4Material(name="MetalIron",density=7.874*g/cm3,ncomponents=1);
metallFe->AddElement(Fe, 1);

density = 2.33*g/cm3;
a = 28.09*g/mole;
G4Material* Sil = new G4Material(name="Silicon", z=14., a, density);

density = 1.117*g/cm3;
G4Material* Pcb = new G4Material(name="Policarbonat", density, ncomponents=3);
Pcb->AddElement(C, natoms=14);
Pcb->AddElement(H, natoms=12);
Pcb->AddElement(O, natoms=3);

density = 0.935*g/cm3;
G4Material* Pol = new G4Material(name="Polyetilen",density,  ncomponents=2);
Pol->AddElement(C,1);
Pol->AddElement(H,2);

density = 1.290*mg/cm3;
G4Material* Air = new G4Material(name="Air"  , density, ncomponents=2);
Air->AddElement(N, fractionmass=0.7);
Air->AddElement(O, fractionmass=0.3);

density = 18.1*g/cm3;
G4Material* Wnc = new G4Material(name="Wnc"  , density, ncomponents=3);
Wnc->AddElement(W, fractionmass=0.95);
Wnc->AddElement(Ni, fractionmass=0.01);
Wnc->AddElement(Cu, fractionmass=0.04);

density = 7.4*g/cm3;
G4Material* NdFeB = new G4Material(name="NdFeB"  , density, ncomponents=2);
NdFeB->AddElement(Fe, fractionmass=0.99);
NdFeB->AddElement(Bel, fractionmass=0.01);
//NdFeB->AddElement(Ndel, fractionmass=0.26.7);

density = 1.032*g/cm3;
G4Material* Sci = new G4Material(name="Scintillator", density, ncomponents=2);
Sci->AddElement(C, natoms=9);
Sci->AddElement(H, natoms=10);

// 97% He3 + 3% Ar
density = 1.39*mg/cm3;  
pressure    = 8.*atmosphere;
temperature = 293.*kelvin;
G4Material* He3Ar = new G4Material(name="HeAr",density, ncomponents=2,
				      kStateGas,temperature,pressure);
He3Ar->AddElement( He3el,fractionmass =  0.694 ) ;
He3Ar->AddElement( Arel,fractionmass = 0.306 ) ;
                

 G4cout << *(G4Isotope::GetIsotopeTable()) << G4endl;
 G4cout << *(G4Element::GetElementTable())   << G4endl;
 G4cout << *(G4Material::GetMaterialTable()) << G4endl;
// ---------------------------------------------------------------------- 
// World  


 solidWorld = new G4Box("World",			//its name
             World_XY/2,World_XY/2,World_Z/2);  	//its size
                         
 logicWorld = new G4LogicalVolume(solidWorld,           //its solid
                                   Air,         	//its material
                                 "World");		//its name
                                   
 physiWorld = new G4PVPlacement(0,	                //no rotation
  			        G4ThreeVector(),	//at (0,0,0)
                                 "World",		//its name
                                 logicWorld,		//its logical volume
                                 NULL,			//its mother  volume
                                 false,			//no boolean operation
                                 0);			//copy number
 //magnet ----------------------------------------------------------------


 
 solidMag = new G4Box("Mag",		                	//its name
             12.1*cm,11.4*cm,22.25*cm);                    	//its size

 solidMagAir = new G4Box("MagAir",		        	//its name
             8.1*cm,6.6*cm,22.25*cm);                     	//its size

 solidMagSiLayer = new G4Box("MagSiLayer",	        	//its name
             8.1*cm,6.6*cm,0.015*cm);                   	//its size
 
 solidMagSiPlate = new G4Box("MagSiPlate",		        //its name
             2.59335*cm,3.3*cm,0.015*cm);                   //its size

 //. . . . . . . . . . . . . . . . . . . .  . . . . . . . . . . . . . .
 logicMag = new G4LogicalVolume(solidMag,                       //its solid
                                  NdFeB,                	//its material
                                 "Mag");		        //its name

 // logicMagAir = new G4LogicalVolume(solidMagAir,                 //its solid
 //                                  Air,                 	//its material
 //                                "MagAir");	        	//its name


 G4double fieldValue = 4.*kilogauss;

  G4UniformMagField* intField
    = new G4UniformMagField(G4ThreeVector(0.,0.,fieldValue));

  G4Mag_UsualEqRhs* iEquation = new G4Mag_UsualEqRhs(intField);

  G4MagIntegratorStepper* iStepper = new G4ClassicalRK4(iEquation);

  G4ChordFinder* iChordFinder = new G4ChordFinder(intField,1.0e-2*mm,iStepper);

  G4FieldManager* fieldMgr = new G4FieldManager(intField,iChordFinder);

  logicMagAir  =
    new G4LogicalVolume(solidMagAir,
			Air,
			"logcMagAir",
                        fieldMgr,0,0);
                                                                                   
  // . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
 logicMagSiLayer = new G4LogicalVolume(solidMagSiLayer,         //its solid
                                   Sil,                      	//its material
                                 "MagSilLayer");		//its name

 logicMagSiPlate = new G4LogicalVolume(solidMagSiPlate,         //its solid
                                   Sil,                      	//its material
                                 "MagSilPlate");		//its name

 // . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
 physiMag = new G4PVPlacement(0,                                 //no rotation
	              G4ThreeVector(0.,0.,-22.25*cm),            //its position
	                                     "Mag",              //its name
				                  logicMag,      //its logical volume
				                 physiWorld,     //its mother
				                   false,        //no boulean operat
				  		0);              //copy number  



 physiMagAir = new G4PVPlacement(0,                          //no rotation
				 G4ThreeVector( 0.,0.,0.),   //its position
				 "MagAir",                   //its name
				 logicMagAir,                //logical volume
				 physiMag,                   //its mother
				 false,                      //no boulean operat
				 0);                         //copy number  
	   

 // place strip detector  plane in the magnet
 for(G4int J=0; J<6; J++) {
   G4double  StZ=(-22.235 +J*8.894)*cm; 
        
      physiMagSiLayer = new G4PVPlacement(0,                   //no rotation
				 G4ThreeVector(0.,0.,StZ),    //its position
				 "MagSiLayer",                 //its name
				 logicMagSiLayer,              //logical volume
				 physiMagAir,                  //its mother
				 false,                        //no boulean operat
				 J);                           //copy number  
 }

 // place strip detector in the plane

G4int copyNo=0;

for(G4int iim=0; iim<2; iim++)
   {
    for(G4int jjm=0; jjm<3; jjm++)
       {
	 G4double Y = ((2*iim-1)*3.3)*cm;
	 G4double X = ((jjm-1)*5.4)*cm;                        

	 physiMagSiPlate = new G4PVPlacement(0,                     //no rotation
					    G4ThreeVector(X, Y, 0), //at 
					    "physiMagSiPlate",      //name
					    logicMagSiPlate,        //logical volume
					    physiMagSiLayer,        //mother  volume
					    false,                  //boolean operation
					    copyNo++);	            //copy number	
       }
   }







 // Polyetilen plate--------------------------------------------------

solidPol = new G4Box("Polietil",21.2*cm,21.2*cm,0.95*cm); 
logicPol = new G4LogicalVolume(solidPol,Pol,"PolPlate");


G4double pos_Z[5];
	      pos_Z[0]= (25.6 + 0.95)*cm;
	      pos_Z[1]=  pos_Z[0] + 2.*cm+ 2*0.95*cm;
	      pos_Z[2]=  pos_Z[1] + 2.*cm+ 2*0.95*cm;
	      pos_Z[3]=  pos_Z[2] + 2*0.95*cm;
	      pos_Z[4]=  pos_Z[3] + 2*0.95*cm;
   
for(G4int im=0; im<5; im++)
  {              
    physiPol = new G4PVPlacement(0,	                         //no rotation
				 G4ThreeVector(0.,0.,pos_Z[im]), //position
				 "PolP",                         //its name
				 logicPol,                       //logical volume
				 physiWorld,                     //its mother
				 false,                          //no boulean operat
				 copyNo++);                      //copy number     
  };
	     
 //Neuron detectors----------------------------------------------

Fe_tubs = new G4Tubs("Fe_tubs",0,0.949*cm,10.48*cm, 0,360*deg);
Fe_log = new G4LogicalVolume(Fe_tubs,metallFe,"Fe_L");

He3Ar_tubs = new G4Tubs("He3ArDet_tubs",0,0.9*cm,10.45*cm,0,360*deg);
He3Ar_log = new G4LogicalVolume(He3Ar_tubs, He3Ar,"He3Ar_L");

copyNo=0;

pos_Z[0]=pos_Z[0]+2.*cm;
pos_Z[1]=pos_Z[1]+2.*cm;

G4RotationMatrix* rm = new G4RotationMatrix(G4ThreeVector(1.0,0.0,0.0),halfpi);

  for(G4int j1=0; j1<2; j1++)
  { 
  for(G4int i1=0; i1<18; i1++)
    {    
G4double pos_X = (-17.+2.*i1)*cm;
	  
physiFe = 	  
   new G4PVPlacement(rm,G4ThreeVector(pos_X,0.,pos_Z[j1]),                    
                                           "pysFe",              //its name
                                            Fe_log,              //logical volume
                                           physiWorld,           //its mother
                                           false,                //boulean operat
            			          copyNo++);            //copy number   
   };
 };

   physiHe3Ar = new G4PVPlacement(0,            //no rotation
   		       G4ThreeVector(0.,0.,0.), //position
  		       "physHe3Ar",             //its name
  		       He3Ar_log,               //its logical volume
  		       physiFe,                 //its mother
  		       false,                   //no boulean operat
  		       0);                      //copy number  


// Absorber Wnc ----------------------------------------------------------  
solidAbsorber = new G4Box("Absorber",		                //its name
                         Calor_XY/2.,Calor_XY/2., AbsorberTh/2.); 
                          
logicAbsorber = new G4LogicalVolume(solidAbsorber,              //its solid
      			               Wnc,                     //its material
     			                  "Absorber");          //its name
//--------------------------------------------------------------------------
 // Scintillator plate------------------------------------------------------
solidS1 = new G4Box("S1", 20.4*cm,16.5*cm,0.7*cm); 
logicS1 = new G4LogicalVolume(solidS1,Sci, "S1");
physiS1 = new G4PVPlacement(0,                                    //no rotation
			     G4ThreeVector(0.,0., -77.9*cm ),     //position
			     "S1",                                //name
			     logicS1,                             //logical volume
			     physiWorld,                          //mother
			     false,                               //no boulean operat
			     0);                                  //copy number  
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
solidS2 = new G4Box("S2", 9.*cm,7.5*cm,0.5*cm); 
logicS2 = new G4LogicalVolume(solidS2,Sci, "S2");
physiS2 = new G4PVPlacement(0,                                            //no rotation
			     G4ThreeVector(0.,0., -47.7*cm ),             //position
			     "S2",                                        //name
			     logicS2,                                     //logical volume
			     physiWorld,                                  //mother
			     false,                                       //no boulean operat
			     0);                                          //copy number  
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
solidS3 = new G4Box("S3", 9.*cm,7.5*cm,0.7*cm); 
logicS3 = new G4LogicalVolume(solidS3,Sci, "S3");
physiS3 = new G4PVPlacement(0,                                           //no rotation
			     G4ThreeVector(0.,0., 2.2*cm ),              //position
			     "S3",                                       //name
			     logicS3,                                    //logical volume
			     physiWorld,                                 //mother
			     false,                                      //no boulean operat
			     0);                                         //copy number  
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
solidS4 = new G4Box("S4", 24.1*cm,24.1*cm,0.5*cm); 
logicS4 = new G4LogicalVolume(solidS4,Sci, "S4");
physiS4 = new G4PVPlacement(0,                                            //no rotation
			     G4ThreeVector(0.,0., 24.8*cm ),              //position
		    	     "S4",                                        //name
			     logicS4,                                     //logical volume
			     physiWorld,                                  //mother
			     false,                                       //no boulean operat
			     0);                                          //copy number 
// CAT---------------------------------------------------------------------------------------------
solidCAT = new G4Box("CAT", 22.15*cm,21.25*cm,0.5*cm); 
logicCAT = new G4LogicalVolume(solidCAT,Sci, "CAT");
physiCAT = new G4PVPlacement(0,                                            //no rotation
			     G4ThreeVector(0.,0., -49.5*cm ),              //position
		    	     "CAT",                                        //name
			     logicCAT,                                     //logical volume
			     physiWorld,                                  //mother
			     false,                                       //no boulean operat
			     0);                                          //copy number  
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
solidCAT1 = new G4Box("CAT1", 9.0*cm,7.5*cm,0.5*cm); 
logicCAT1 = new G4LogicalVolume(solidCAT1,Air, "CAT1");
physiCAT1 = new G4PVPlacement(0,                                           //no rotation
			     G4ThreeVector(0.,0., -49.5*cm ),              //position
		    	     "CAT1",                                       //name
			     logicCAT1,                                    //logical volume
			     physiCAT,                                     //mother
			     false,                                        //no boulean operat
			     0);                                           //copy number  
//CAS-----------------------------------------------------------------------------------------------
solidCASX = new G4Box("CASX", 17.5*cm,0.5*cm,19.75*cm); 
logicCASX = new G4LogicalVolume(solidCASX,Sci, "CASX");

for(G4int Jc=0; Jc<2; Jc++) {
   G4double  Y=(2*Jc-1)*15*cm; 
        
      physiCASX = new G4PVPlacement(0,                                  //no rotation
				 G4ThreeVector(0.*cm,Y,-19.75*cm),      //its position
				 "physiCASX",                           //its name
				 logicCASX,                             //logical volume
				 physiWorld,                            //its mother
				 false,                                 //no boulean operat
				 Jc);                                   //copy number  
 }
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
solidCASY = new G4Box("CASY", 0.5*cm,14.5*cm,19.75*cm); 
logicCASY = new G4LogicalVolume(solidCASY,Sci, "CASY");

for(G4int Jv=0; Jv<2; Jv++) {
   G4double  X=(2*Jv-1)*16.75*cm; 
        
      physiCASY = new G4PVPlacement(0,                              //no rotation
				 G4ThreeVector(X,0.*cm,-19.75*cm),    //its position
				 "physiCASY",                       //its name
				 logicCASY,                         //logical volume
				 physiWorld,                        //its mother
				 false,                             //no boulean operat
				 Jv);                               //copy number  
 }

//CARD-----------------------------------------------------------------
solidCARD = new G4Trd("CARD", 19.8*cm,17.6*cm,
		              11.9 *cm,9.8*cm,
		                9.6*cm); 

logicCARD = new G4LogicalVolume(solidCARD,Sci, "CARD");
physiCARD = new G4PVPlacement(0,                                         //no rotation
			    G4ThreeVector(0.*cm,0.*cm, -63.3*cm),        //position
			    "CARD",                                      //name
			    logicCARD,                                   //logical volume
			    physiWorld,                                  //mother
			    false,                                       //no boulean operat
			    0);                                          //copy number  
			  
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .       

solidCARD1 = new G4Trd("CARD1", 18.9*cm,16.8*cm,
		                11.0*cm,8.9*cm,
		                9.6*cm); 

logicCARD1 = new G4LogicalVolume(solidCARD1,Air, "CARD1");
physiCARD1 = new G4PVPlacement(0,                                         //no rotation
			    G4ThreeVector(0.*cm,0.*cm,0*cm),              //position
			    "CARD1",                                      //name
			    logicCARD1,                                   //logical volume
			    physiCARD,                                    //mother
			    false,                                        //no boulean operat
			    0);                                           //copy number  
			  

   //  Al plate --------------------------------------------------------                         
 
solidAl = new G4Box("Alum",24.1*cm,24.1*cm,0.15*cm); 
logicAl = new G4LogicalVolume(solidAl,Al, "AlPlate");
physiAl = new G4PVPlacement(0,                                             //no rotation
			    G4ThreeVector(0.,0., 25.45*cm),                //position
			    "AlumPl",                                      //name
			    logicAl,                                       //logical volume
			    physiWorld,                                    //mother
			    false,                                         //no boulean operat
			    0);                                            //copy number  

// CALORIMETER
// Policarbonat plate------------------------------------------------------------   
solidPcb = new G4Box("PcbPlate",Calor_XY/2.,Calor_XY/2.,PcbTh/2.); 
logicPcb = new G4LogicalVolume(solidPcb,Pcb,"PcbPlate");  
                           
copyNo=0;   
for(G4int is=0; is<11; is++)
   { 
    for(G4int j=0; j<2; j++)
     {    
      G4double Z = (2.*j+1)*CalorSTh/2. + is*(2.*CalorSTh + .2*cm) + 3.8*cm + 0.05*cm;	  
              
      physiPcb = new G4PVPlacement(0,	                  //no rotation
	              		   G4ThreeVector(0.,0.,Z),//position
				   "physPcb",             //name
				   logicPcb,              //logical volume
				   physiWorld,            //mother
				   false,                 //boulean operat
				   copyNo++);             //copy number     
     };
   };

//Silicon  Layer -------------------------------------------------------
solidSiLayerY = new G4Box("SiLayerY",Calor_XY/2.,Calor_XY/2.,SiLayerTh/2.);      
logicSiLayerY = new G4LogicalVolume(solidSiLayerY, Sil, "SiLayerY");

  copyNo=0;
for(G4int iy=0; iy<11; iy++)
   { 
   for(G4int j=0; j<2; j++)
    {    
      G4double Z = (j+1)*CalorSTh -SiLayerTh/2 + iy*(2.*CalorSTh + .2*cm) + 3.8*cm;	  
	     
      physiSiLayerY = new G4PVPlacement(0,	                //no rotation
					G4ThreeVector(0.,0.,Z), // position
					"SiLayerY",             //name
					logicSiLayerY,          //logical volume
					physiWorld,             //mother
					false,                  //boulean operat
					copyNo++);              //copy number     
    };
   };
// . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .

solidSiLayerX = new G4Box("SiLayerX",Calor_XY/2.,Calor_XY/2.,SiLayerTh/2.);                         
logicSiLayerX = new G4LogicalVolume(solidSiLayerX,Sil, "SiLayerX");     

copyNo=0;
for(G4int ix=0; ix<11; ix++)
   { 
    for(G4int j=0; j<2; j++)
     {    
       G4double Z = j*CalorSTh + 0.1*cm +SiLayerTh/2 + ix*(2.*CalorSTh + .2*cm) + 3.8*cm;
	   	  
       physiSiLayerX = new G4PVPlacement(0,	                //no rotation
					 G4ThreeVector(0.,0.,Z),//position
					 "SiLayerX",            //name
					 logicSiLayerX,         //logical volume
					 physiWorld,            //mother
					 false,                 //boulean operat
					 copyNo++);             //copy number     
     };
   };


 // Strip plate ---------------------------------------------------------
G4double StrXY =8.*cm;
solidStrPlateY = new G4Box("StrPlateXYsol", StrXY/2, StrXY/2,SiLayerTh/2);			   
logicStrPlateY = new G4LogicalVolume(solidStrPlateY,Sil,"StrPlateYlog");  
			 
solidStrPlateX = new G4Box("StrPlateXsol", StrXY/2, StrXY/2, SiLayerTh/2);
logicStrPlateX = new G4LogicalVolume(solidStrPlateX, Sil, "StrPlateXlog");  

copyNo=0;
for(G4int ii=0; ii<3; ii++)
   {
    for(G4int jj=0; jj<3; jj++)
       {
	 G4double Y = (8.15*(ii-1))*cm;
	 G4double X = (8.15*(jj-1))*cm;                        

	 physiStrPlateX = new G4PVPlacement(0,                     //no rotation
					    G4ThreeVector(X, Y, 0),//at 
					    "StrPlateXphys",       //name
					    logicStrPlateX,        //logical volume
					    physiSiLayerX,         //mother  volume
					    false,                 //boolean operation
					    copyNo++);	           //copy number	
       };
   };
    

 copyNo=0;
 for(G4int i=0; i<3; i++)
   {
     for(G4int jj=0; jj<3; jj++)
      {
	 G4double Y = (8.15*(i-1))*cm;
	 G4double X = (8.15*(jj-1))*cm;                        

	 physiStrPlateY = new G4PVPlacement(0,                          //no rotation
					    G4ThreeVector(X, Y, 0),      //at		                          
					    "StrPlateYphys",    	//name
					    logicStrPlateY,     	//logical volume
					    physiSiLayerY,            	//mother  volume
					    false,	                //boolean operation
		                         copyNo++);	        	//copy number	
			  	   };
			  	  };

 // Si line----------------------------------------------------------------
solidStrX_L = new G4Box("StrX_L", 1.2*mm, StrXY/2,  SiLayerTh/2);
solidStrY_L = new G4Box("StrY_L", StrXY/2, 1.2*mm, SiLayerTh/2);

logicStrX_L = new G4LogicalVolume(solidStrX_L, Sil,"StrX_L");        
logicStrY_L = new G4LogicalVolume(solidStrY_L, Sil, "StrY_L");        
  
for(G4int j=0; j<32; j++)
  {
    G4double Y = (-40+1.3+j*2.5)*mm;
	                         
    physiStrY_L = new G4PVPlacement(0,                      //no rotation
				    G4ThreeVector(0, Y, 0), //at 
	                            "StrY_L",               //its name
				    logicStrY_L,            //its logical volume
				    physiStrPlateY,         //its mother  volume
				    false,	            //no boolean operation
				    j);	                    //copy number	
  }
	
     
  
for(G4int k=0; k<32; k++)
  {
    G4double X = (-40+1.3+k*2.5)*mm;
	                         
    physiStrX_L = new G4PVPlacement(0,                      //no rotation
				    G4ThreeVector(X, 0, 0), //at 
				    "StrZ_L",               //its name
				    logicStrX_L,            //its logical volume
				    physiStrPlateX,         //its mother  volume
				    false,	            //no boolean operation
				    k);                     //copy number	
  };
	   


 //---------------------------------------------------------------------

physiAbsorber = new G4PVPlacement(0,                         //no rotation
				  G4ThreeVector(0.,0.,0.),   //its position
				  "Absorber",                //its name
				  logicAbsorber,             //its logical volume
                                  physiPcb,                  //its mother
				  false,                     //no boulean operat
				  0);                        //copy number  
 





  // Visualization attributes-------------------------------------------------  
logicWorld->SetVisAttributes(G4VisAttributes::Invisible);

G4VisAttributes* SiLayerVisAtt = new G4VisAttributes(G4Colour(1.,1.,1.));
SiLayerVisAtt->SetForceWireframe(true);
logicSiLayerY->SetVisAttributes(SiLayerVisAtt); 
logicSiLayerX->SetVisAttributes(SiLayerVisAtt); 

G4VisAttributes* StrVisAtt= new G4VisAttributes(G4Colour(1.,0.5,0.0));
StrVisAtt->SetForceWireframe(true);
logicStrPlateY->SetVisAttributes(StrVisAtt); 
logicStrPlateX->SetVisAttributes(StrVisAtt); 

G4VisAttributes* StrVisLZAtt=new G4VisAttributes(G4Colour(1.,0.5,0.6));
StrVisLZAtt->SetForceWireframe(true);

G4VisAttributes* StrVisLYAtt= new G4VisAttributes(G4Colour(0.0,0.5,0.6));
StrVisLYAtt->SetForceWireframe(true);
logicStrX_L->SetVisAttributes(StrVisLZAtt); 
logicStrY_L->SetVisAttributes(StrVisLYAtt); 

G4VisAttributes* AbsorberVisAtt= new G4VisAttributes(G4Colour(1.,0.,1.));
AbsorberVisAtt->SetForceWireframe(true);
logicAbsorber->SetVisAttributes(AbsorberVisAtt); 
    
G4VisAttributes* PcbVisAtt= new G4VisAttributes(G4Colour(0.5,0.0,1.0));
PcbVisAtt->SetForceWireframe(true);
logicPcb->SetVisAttributes(PcbVisAtt); 

G4VisAttributes* EVisAtt= new G4VisAttributes(G4Colour(0.0,0.5,0.));
EVisAtt->SetForceWireframe(true);
logicS4->SetVisAttributes(EVisAtt); 
logicS3->SetVisAttributes(EVisAtt); 
logicS2->SetVisAttributes(EVisAtt); 
logicS1->SetVisAttributes(EVisAtt); 
logicCAT->SetVisAttributes(EVisAtt); 
logicCAT1->SetVisAttributes(EVisAtt); 
logicCARD->SetVisAttributes(EVisAtt); 
logicCARD1->SetVisAttributes(EVisAtt); 
logicCASX->SetVisAttributes(EVisAtt); 
logicCASY->SetVisAttributes(EVisAtt); 

G4VisAttributes* AlAtt= new G4VisAttributes(G4Colour(0.8,0.1,0.7));
AlAtt->SetForceWireframe(true);
logicAl->SetVisAttributes(AlAtt); 
   
G4VisAttributes* MagAtt= new G4VisAttributes(G4Colour(0.8,0.5,0.7));
MagAtt->SetForceWireframe(true);
logicMag->SetVisAttributes(MagAtt);  

G4VisAttributes* MagSilAtt= new G4VisAttributes(G4Colour(0.2,0.1,0.7));
MagSilAtt->SetForceWireframe(true);
logicMagSiLayer->SetVisAttributes(MagSilAtt);  

G4VisAttributes* MagPlateAtt= new G4VisAttributes(G4Colour(0.8,0.1,0.7));
MagPlateAtt->SetForceWireframe(true);
logicMagSiPlate->SetVisAttributes(MagPlateAtt);  

G4VisAttributes* FeAtt= new G4VisAttributes(G4Colour(0.0,0.1,0.7));
FeAtt->SetForceWireframe(true);
Fe_log->SetVisAttributes(FeAtt);

G4VisAttributes* polAtt=  new G4VisAttributes(G4Colour(0.3,0.1,1.));
polAtt->SetForceWireframe(true);
logicPol->SetVisAttributes(polAtt); 

G4VisAttributes* MagAirAtt= new G4VisAttributes(G4Colour(0.1,0.5,0.7));
MagAirAtt->SetForceWireframe(true);
logicMagAir->SetVisAttributes(MagAirAtt); 
   
G4VisAttributes* He3ArAtt= new G4VisAttributes(G4Colour(.4,0.1,0.1));
He3ArAtt->SetForceWireframe(true);
He3Ar_log->SetVisAttributes(He3ArAtt); 

  return physiWorld;
}


// 2005 by G.I.Vasilyev











