

#include "G4RunManager.hh"
#include "G4UImanager.hh"
#include "G4UIterminal.hh"
#include "G4UItcsh.hh"


#include "Randomize.hh"

#ifdef G4VIS_USE
#include "VisManager.hh"
#endif

#include "DetectorConstruction.hh"
#include "PhysicsList.hh"
#include "PrimaryGeneratorAction.hh"
#include "RunAction.hh"
#include "EventAction.hh"
#include "SteppingAction.hh"
#include "SteppingVerbose.hh"
#include "TrackingAction.hh"



int main(int argc,char** argv) {

  // choose the Random engine----------------------------------
  //    G4int index=5;
  //   G4long seeds[2];  
  //    HepRandom::getTheTableSeeds(seeds,index); 
  //    HepRandom::setTheSeed(345354);  
   //    HepRandom::setTheSeed(975354);  
  //     HepRandom::setTheSeed(1299961164);  
  //   HepRandom::setTheSeed(16697008517);  
  //   HepRandom::setTheSeed(190904760);  
  //   HepRandom::setTheSeed(59502945);  
 //   HepRandom::setTheSeed(350557787);  
  //   HepRandom::setTheSeed(489854550);  
  //   HepRandom::setTheEngine(new RanecuEngine);
	  // G4int index=2;
	  // G4long seeds[2];
	  // const G4long* table;
	  // table = HepRandom::getTheSeeds();    
	  // HepRandom::setTheSeeds(seeds,index); 

  // HepRandom::setTheEngine(new RanluxEngine);
  //     HepRandom::setTheSeed(
			     //     19780503
			     //  29780503
			     //    19781543
			     //  23781519
  //           ,4);

  //my Verbose output class
    G4VSteppingVerbose::SetInstance(new SteppingVerbose);
     
  // Construct the default run manager
  G4RunManager * runManager = new G4RunManager;

  // set mandatory initialization classes
  DetectorConstruction* detector = new DetectorConstruction;
         RunAction* run = new RunAction;
  runManager->SetUserInitialization(detector);
   runManager->SetUserInitialization(new PhysicsList);

#ifdef G4VIS_USE
  // Visualization, if you choose to have it!
   G4VisManager* visManager = new VisManager;
   visManager->Initialize();
#endif

   // set user action classes
  runManager->SetUserAction(new PrimaryGeneratorAction(detector));
  runManager->SetUserAction(new RunAction);
  runManager->SetUserAction(new EventAction(run));
  runManager->SetUserAction(new SteppingAction(detector,run));
  runManager->SetUserAction(new TrackingAction);


  runManager->Initialize();
    
  // get the pointer to the User Interface manager 
  G4UImanager* UI = G4UImanager::GetUIpointer();  

if(argc==1)
  // Define (G)UI terminal for interactive mode  
  { 
    // G4UIterminal is a (dumb) terminal.
    G4UIsession * session = 0;
#ifdef G4UI_USE_TCSH
      session = new G4UIterminal(new G4UItcsh);      
#else
      session = new G4UIterminal();
#endif    

    UI->ApplyCommand("/control/execute vi.mac");    
    session->SessionStart();
    delete session;
  }
  else
  // Batch mode
  { 
    G4String command = "/control/execute ";
    G4String fileName = argv[1];
    UI->ApplyCommand(command+fileName);
  }

#ifdef G4VIS_USE
    delete visManager;
#endif
  delete runManager;

  return 0;
}

2005 by G.I.Vasilye
