/*
 * TrkRunValCut.h
 *
 *  Created on: 24-mar-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkRunValCut.h The TrkRunValCut class definition file */

#ifndef TRKRUNVALCUT_H_
#define TRKRUNVALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker run validation cut.
 */
class TrkRunValCut: public PamCut {

public:
  /*! @brief Constructor. */
  TrkRunValCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~TrkRunValCut() {
  }

  /*! @brief The tracker run validation check.
   *
   * This method checks the tracker run validation variable, which must be 1 or 2.
   *
   * @param event The event to analyze.
   * @return #CUTOK if tracker calibration is online or default.
   */
  int Check(PamLevel2 *event);

private:

};
#endif /* TRKRUNVALCUT_H_ */
