/*
 * TrkRigRangeCut.h
 *
 *  Created on: 24-apr-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkRigRangeCut.h The TrkRigRangeCut class definition file */

#ifndef TRKRIGRANGECUT_H_
#define TRKRIGRANGECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The rigidity range cut.
 * This cut discards all the events whose rigidity is less than the minimum threshold or greater than the maximum threshold.
 * Here rigidity is defined as p/Z (GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus: therefore rigidity can be positive or negative.
 */
class TrkRigRangeCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param minRigidity The minimum rigidity p/Z (in GV) below which an event
   *        will be discarded. Can be positive or negative.
   * @param maxRigidity The maximum rigidity p/Z (in GV) above which an event
   *        will be discarded. Can be positive or negative.
   */
  TrkRigRangeCut(const char *cutName, float minRigidity, float maxRigidity) :
    PamCut(cutName), _minRigidity(minRigidity), _maxRigidity(maxRigidity) {
  }
  /*! @brief Destructor. */
  ~TrkRigRangeCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the rigidity is outside the range
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _minRigidity;
  float _maxRigidity;

};
#endif /* TRKRIGRANGECUT_H_ */
