/*
 * TrkRigMDRCut.h
 *
 *  Created on: 07/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TrkRigMDRCut.h The TrkRigMDRCut class definition file */

#ifndef TRKRIGMDRCUT_H_
#define TRKRIGMDRCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The rigidity cut.
 * This cut discards all the events whose absolute rigidity multiplied by a constant
 * factor is greater than the MDR.
 */
class TrkRigMDRCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param MDRFactor The MDR Factor (see #Check).
   */
  TrkRigMDRCut(const char *cutName, float MDRFactor = 1.) :
    PamCut(cutName), _MDRFactor(MDRFactor) {
  }
  /*! @brief Destructor. */
  ~TrkRigMDRCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if |R|*MDRFactor <= MDR
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _MDRFactor;

};
#endif /* TRKRIGMDRCUT_H_ */
